/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.loots;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.loots.LootAcquired;
import com.xericker.mysteryboxes.core.events.opening.utils.OpenEffects;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.loots.HistoryData;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import java.util.ArrayList;
import java.util.List;
import libraries.RandomCollection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;

public class LootHandler {
    public static List<Loot> getLoots(Player player, Box box, int n) {
        ArrayList<Loot> arrayList = new ArrayList<Loot>();
        ArrayList<Loot> arrayList2 = new ArrayList<Loot>(box.getLoots().keySet());
        RandomCollection<Loot> randomCollection = new RandomCollection<Loot>();
        double d = 0.0;
        UpgradeData upgradeData = UpgradeManager.getData(Upgrade.TREASURE_HUNTER);
        if (upgradeData != null) {
            d = upgradeData.getInterface().getBonus(player);
        }
        for (Loot loot : arrayList2) {
            boolean bl = loot.getLootSettings().valuable;
            double d2 = box.getLoots().get(loot);
            if (bl) {
                d2 += d2 * (d / 100.0);
            }
            randomCollection.add(d2, loot);
        }
        for (int i = 0; i < n; ++i) {
            arrayList.add((Loot)randomCollection.next());
        }
        return arrayList;
    }

    public static void claimLoot(Player player, OpenEvent openEvent, Box box, LootAcquired lootAcquired, ArmorStand armorStand) {
        PlayerData playerData = PlayerDataManager.getData(player);
        Loot loot = lootAcquired.getLoot();
        OpenEffects.playEffects(player, openEvent, loot, armorStand);
        OpenEffects.playSounds(player, armorStand, loot);
        OpenEffects.spawnFireworks(player, armorStand, loot);
        LootHandler.lootBroadcasts(player, box, loot);
        LootHandler.lootCommands(player, box, loot);
        playerData.setStatistic(Statistic.BOXES_OPENED, playerData.getStatistic(Statistic.BOXES_OPENED) + 1L);
        playerData.setTimestamp(Timestamp.BOX_OPEN, System.currentTimeMillis());
        Long l = LootHandler.calculateDustToGive(player, loot, lootAcquired.getLootReveal());
        if (l > 0L) {
            playerData.setDust(playerData.getDust() + l.intValue());
        }
        String string = loot.getLootSettings().name;
        string = string.replace("{DUST_TO_GIVE}", String.valueOf(l));
        HistoryData historyData = new HistoryData(playerData);
        historyData.setLootName(string);
        historyData.setBoxName(box.getBoxSettings().name);
        playerData.getHistoryList().add(historyData);
        if (playerData.getBoxes(box) > 0) {
            playerData.setBoxes(box, playerData.getBoxes(box) - 1);
        }
        playerData.getLootDiscovered().add(loot);
    }

    public static void lootMessages(Player player, Box box, List<LootAcquired> list) {
        String string;
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string3 = ConfigParser.getString(LanguageValue.LOOT_PLACEHOLDER_DISCOVER);
        if (string3 == null) {
            string3 = "discoverPlaceholder=NULL";
        }
        if ((string2 = ConfigParser.getString(LanguageValue.LOOT_PLACEHOLDER_DUPLICATE)) == null) {
            string2 = "duplicatePlaceholder=NULL";
        }
        if ((string = ConfigParser.getString(LanguageValue.LOOT_PLACEHOLDER_COMPENSATION)) == null) {
            string = "compensationPlaceholder=NULL";
        }
        List<String> list2 = ConfigParser.getStringList(list.size() == 1 ? LanguageValue.LOOT_MESSAGES_SINGLE : LanguageValue.LOOT_MESSAGES_MULTIPLE);
        String string4 = "{LOOT_PLACEHOLDER}";
        long l = 0L;
        boolean bl = false;
        for (String string5 : list2) {
            if (!string5.contains(string4)) {
                arrayList.add(string5);
                continue;
            }
            for (LootAcquired lootAcquired : list) {
                Loot loot = lootAcquired.getLoot();
                LootReveal lootReveal = lootAcquired.getLootReveal();
                long l2 = LootHandler.calculateDustToGive(player, loot, lootReveal);
                if (lootReveal == LootReveal.DUPLICATED) {
                    l += l2;
                    bl = true;
                }
                String string6 = string5.replace(string4, lootAcquired.getLootReveal() == LootReveal.DISCOVERED ? string3 : string2);
                string6 = GeneralPlaceholders.translate((Object)player, box, loot, string6);
                string6 = string6.replace("{DUST_TO_GIVE}", String.valueOf(l2));
                arrayList.add(GeneralPlaceholders.translate((Object)player, box, loot, string6));
            }
            if (!bl) continue;
            String string7 = string5.replace(string4, string);
            arrayList.add(string7);
            bl = false;
        }
        for (String string8 : arrayList) {
            String string10 = GeneralPlaceholders.translate((Object)player, box, string8);
            string10 = string10.replace("{DUST_TO_GIVE}", String.valueOf(l));
            player.sendMessage(string10);
        }
    }

    public static void lootBroadcasts(Player player, Box box, Loot loot) {
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(player);
        for (String string : loot.getBroadcastsSettings((LootReveal)lootReveal).broadcasts) {
            string = GeneralPlaceholders.translate((Object)player, box, loot, string);
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (player2 == player) continue;
                player2.sendMessage(string);
            }
        }
    }

    public static void lootCommands(Player player, Box box, Loot loot) {
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(player);
        Loot.CommandsSettings commandsSettings = loot.getCommandsSettings(lootReveal);
        boolean bl = commandsSettings.asPlayer;
        List<String> list = commandsSettings.commands;
        long l = LootHandler.calculateDustToGive(player, loot, lootReveal);
        for (String string : list) {
            string = GeneralPlaceholders.translate((Object)player, box, loot, string);
            string = string.replace("{DUST_TO_GIVE}", String.valueOf(l));
            if (bl) {
                player.performCommand(string);
                continue;
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string);
        }
    }

    public static long calculateDustToGive(Player player, Loot loot, LootReveal lootReveal) {
        double d = 0.0;
        UpgradeData upgradeData = UpgradeManager.getData(Upgrade.DUST_COLLECTOR);
        if (upgradeData != null) {
            d = upgradeData.getInterface().getBonus(player);
        }
        int n = 0;
        int n2 = loot.getDuplicateSettings((LootReveal)lootReveal).dustToGive;
        if (n2 > 0) {
            n2 += (int)Math.round((double)n2 * d / 100.0);
            n += n2;
        }
        return n;
    }
}

