/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening.themes.custom;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.core.events.opening.OpenEvent;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeExecutor;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import utils.LocationUtils;

public class ApocalypseTheme
implements ThemeExecutor {
    private OpenEvent openEvent;
    private Location eventLocation;
    private Map<Block, Material> terrainBlocks;
    private List<Block> scorchedBlocks;
    private List<Block> meteorTargets;
    private Map<ArmorStand, Vector> meteorEntities;
    private Map<ArmorStand, Long> meteorTimeSpans;

    @Override
    public void startTheme(OpenEvent openEvent) {
        this.openEvent = openEvent;
        this.generateTerrain();
    }

    @Override
    public void stopTheme() {
        for (Block block : this.terrainBlocks.keySet()) {
            block.getState().update();
        }
        for (ArmorStand armorStand : this.meteorEntities.keySet()) {
            armorStand.remove();
        }
    }

    public void generateTerrain() {
        this.terrainBlocks = new HashMap<Block, Material>();
        this.scorchedBlocks = new ArrayList<Block>();
        this.meteorTargets = new ArrayList<Block>();
        this.meteorEntities = new HashMap<ArmorStand, Vector>();
        this.meteorTimeSpans = new HashMap<ArmorStand, Long>();
        this.eventLocation = this.openEvent.getEventLocation();
        if (this.openEvent.getOpenData().vault != null) {
            this.eventLocation.setY((double)this.eventLocation.getBlockY());
            this.eventLocation.subtract(0.0, 1.0, 0.0);
        }
        LocationUtils.setSolidBlock(this.eventLocation, BlockFace.DOWN);
        new BukkitRunnable(){
            int terrainStep = 4;
            int terrainRadius = 3;
            float soundPitch = 0.75f;

            public void run() {
                if (ApocalypseTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                --this.terrainStep;
                if (this.terrainStep == 0) {
                    ApocalypseTheme.this.startApocalypse();
                    ApocalypseTheme.this.startScorchedGround();
                    this.cancel();
                    return;
                }
                this.soundPitch = (float)((double)this.soundPitch + 0.25);
                ApocalypseTheme.this.eventLocation.getWorld().playSound(ApocalypseTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, this.soundPitch);
                ApocalypseTheme.this.eventLocation.getWorld().playSound(ApocalypseTheme.this.eventLocation, Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.25f, this.soundPitch);
                for (Block block : LocationUtils.getCube(ApocalypseTheme.this.eventLocation, this.terrainRadius)) {
                    if (ApocalypseTheme.this.terrainBlocks.containsKey(block) || block.isEmpty() || !block.getRelative(BlockFace.UP).isEmpty() && ApocalypseTheme.this.eventLocation.getY() - (double)block.getY() > 0.5 || VaultData.getVault(block.getRelative(BlockFace.UP).getLocation()) != null || VaultData.getVault(block.getLocation()) != null) continue;
                    Material material = Main.getRandom().nextBoolean() ? Material.GRASS_BLOCK : Material.DIRT;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        BlockData blockData = Bukkit.createBlockData((Material)material);
                        player.sendBlockChange(block.getLocation(), blockData);
                    }
                    ApocalypseTheme.this.terrainBlocks.put(block, material);
                    ApocalypseTheme.this.meteorTargets.add(block);
                }
                this.terrainRadius += 2;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 10L);
    }

    public void startApocalypse() {
        new BukkitRunnable(){
            int animationStep = 0;

            public void run() {
                if (ApocalypseTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    Location location = new Location(ApocalypseTheme.this.eventLocation.getWorld(), ApocalypseTheme.this.eventLocation.getX() + (Main.getRandom().nextDouble() - 0.5) * 20.0, ApocalypseTheme.this.eventLocation.getY() + 12.0 + (Main.getRandom().nextDouble() - 0.5) * 7.0, ApocalypseTheme.this.eventLocation.getZ() + (Main.getRandom().nextDouble() - 0.5) * 20.0);
                    Location location2 = null;
                    if (ApocalypseTheme.this.meteorTargets.size() > 0) {
                        var4_4 = ApocalypseTheme.this.meteorTargets.get(Main.getRandom().nextInt(ApocalypseTheme.this.meteorTargets.size()));
                        location2 = var4_4.getLocation();
                        ApocalypseTheme.this.meteorTargets.remove(var4_4);
                    } else {
                        var4_4 = new ArrayList(ApocalypseTheme.this.terrainBlocks.keySet());
                        Block block = (Block)var4_4.get(Main.getRandom().nextInt(var4_4.size()));
                        location2 = block.getLocation();
                    }
                    ApocalypseTheme.this.spawnMeteor(location, location2);
                }
                ++this.animationStep;
                if (this.animationStep == 10) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 12L);
    }

    public void startScorchedGround() {
        new BukkitRunnable(){
            int finishStep = 0;
            boolean finished = false;

            public void run() {
                if (ApocalypseTheme.this.openEvent.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                for (Block object : ApocalypseTheme.this.scorchedBlocks) {
                    if (Main.getRandom().nextInt(200) >= 1) continue;
                    object.getWorld().spawnParticle(Particle.LAVA, object.getLocation(), 1, 0.0, 2.0, 0.0, 1.0);
                }
                if (this.finished) {
                    ++this.finishStep;
                    return;
                }
                for (ArmorStand armorStand : ApocalypseTheme.this.meteorEntities.keySet()) {
                    if (armorStand.isDead()) continue;
                    ApocalypseTheme.this.meteorTimeSpans.put(armorStand, ApocalypseTheme.this.meteorTimeSpans.getOrDefault(armorStand, 0L) + 1L);
                    ArmorStand armorStand2 = armorStand.getLocation().add(ApocalypseTheme.this.meteorEntities.get(armorStand));
                    armorStand.teleport((Location)armorStand2);
                    armorStand.getWorld().spawnParticle(Particle.FLAME, armorStand.getEyeLocation().add(0.0, 0.15, 0.0), 1, 0.0, 0.0, 0.0, 0.0);
                    Location location = armorStand.getEyeLocation().add(0.0, 1.0, 0.0);
                    Block block = location.getBlock();
                    if (block.isEmpty()) continue;
                    armorStand.remove();
                    for (Block block2 : LocationUtils.getCube(block.getLocation(), 3)) {
                        if (!ApocalypseTheme.this.terrainBlocks.containsKey(block2)) continue;
                        Material material = Main.getRandom().nextBoolean() ? Material.OBSIDIAN : Material.MAGMA_BLOCK;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            BlockData blockData = Bukkit.createBlockData((Material)material);
                            player.sendBlockChange(block2.getLocation(), blockData);
                        }
                        ApocalypseTheme.this.scorchedBlocks.add(block);
                    }
                    Location location2 = LocationUtils.setAirBlock(armorStand.getLocation(), BlockFace.UP);
                    location2.subtract(0.0, 0.25, 0.0);
                    for (Material material : LocationUtils.getCircle(location2, 0.15, 20)) {
                        Vector vector = material.toVector().subtract(location2.toVector()).normalize();
                        armorStand.getWorld().spawnParticle(Particle.FLAME, material.getX(), material.getY(), material.getZ(), 0, vector.getX(), vector.getY(), vector.getZ(), 0.15);
                    }
                    armorStand.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, location2, 1, 0.0, 0.0, 0.0, 1.0);
                    armorStand.getWorld().playSound(location2, Sound.ENTITY_GENERIC_EXPLODE, 0.25f, 1.0f);
                    armorStand.getWorld().playSound(location2, Sound.BLOCK_LAVA_EXTINGUISH, 0.15f, 1.0f);
                }
                if (!this.finished && ApocalypseTheme.this.meteorEntities.size() > 0) {
                    int n = 0;
                    for (ArmorStand armorStand2 : ApocalypseTheme.this.meteorEntities.keySet()) {
                        if (ApocalypseTheme.this.meteorTimeSpans.get(armorStand2) > 100L) {
                            armorStand2.remove();
                        }
                        if (!armorStand2.isDead()) continue;
                        ++n;
                    }
                    if (n == ApocalypseTheme.this.meteorEntities.size()) {
                        this.finished = true;
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 1L);
    }

    public void spawnMeteor(Location location, Location location2) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location.clone().subtract(0.0, 0.5, 0.0), ArmorStand.class);
        armorStand.setMetadata(Main.getMetadataValue(), (MetadataValue)Main.getFixedMetadataValue());
        armorStand.setVisible(false);
        armorStand.setSilent(true);
        armorStand.setInvulnerable(true);
        armorStand.setGravity(false);
        armorStand.setMarker(false);
        String[] stringArray = new String[]{"https://textures.minecraft.net/texture/990cbd72e41a9bd411be929b73fd269206368b2810d6c6819918cb8eb66224f4", "https://textures.minecraft.net/texture/67c41930f8ff0f2b0430e169ae5f38e984df1244215705c6f173862844543e9d"};
        Vector vector = location2.clone().toVector().subtract(armorStand.getLocation().toVector()).normalize();
        vector = vector.multiply(0.75 + Main.getRandom().nextDouble() / 1.75);
        this.meteorEntities.put(armorStand, vector);
        EulerAngle eulerAngle = new EulerAngle(vector.getX(), vector.getY(), vector.getZ());
        armorStand.setHeadPose(eulerAngle);
    }
}

