/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults.editor;

import com.xericker.mysteryboxes.config.handlers.ConfigFile;
import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.core.vaults.VaultData;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import utils.MessageUtils;
import utils.WorldUtils;

public class EditorHandler {
    public static void enableEditor(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        playerData.setVaultAction(VaultAction.VAULT_EDITOR);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
    }

    public static void disableEditor(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        playerData.setVaultAction(null);
        MessageUtils.sendBar(player, Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f, "");
    }

    public static void createVault(Player player, Location location) {
        if (VaultData.getVault(location) != null) {
            MessageUtils.sendTitle(player, Sound.ENTITY_ITEM_BREAK, 1.0f, 0.0f, 0, 40, 0, "\u00a7c\u26a0 Vault Already Exists", "\u00a77Another Vault exists at this location.");
            return;
        }
        Vault.writeVault(location);
        ConfigFile.VAULT_DATA.saveFile();
        ConfigFile.registerFiles();
        WorldUtils.playStepSound(location, location.getBlock().getType(), 1);
        MessageUtils.sendTitle(player, Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f, 0, 40, 0, "\u00a7a\u2714Vault Created", "\u00a77The Mystery Vault was created.");
        EditorHandler.disableEditor(player);
    }

    public static void removeVault(Player player, Location location) {
        Vault vault = VaultData.getVault(location);
        if (vault == null) {
            MessageUtils.sendTitle(player, Sound.ENTITY_ITEM_BREAK, 1.0f, 0.0f, 0, 40, 0, "\u00a7c\u26a0 Vault Does Not Exist", "\u00a77Could not find any Vault at this location.");
            return;
        }
        if (vault.getVaultAction() != null) {
            MessageUtils.sendTitle(player, Sound.ENTITY_ITEM_BREAK, 1.0f, 0.0f, 0, 40, 0, "\u00a7c\u26a0 Vault Is Busy", "\u00a7cWait before removing this Vault.");
            return;
        }
        Vault.eraseVault(location);
        ConfigFile.VAULT_DATA.saveFile();
        ConfigFile.registerFiles();
        WorldUtils.playStepSound(location, location.getBlock().getType(), 1);
        MessageUtils.sendTitle(player, Sound.BLOCK_ENDER_CHEST_CLOSE, 1.0f, 1.0f, 0, 40, 0, "\u00a7a\u2714Vault Removed", "\u00a77The Mystery Vault was removed.");
        EditorHandler.disableEditor(player);
    }
}

