/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.loots;

import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.effects.EffectStatus;
import com.xericker.mysteryboxes.core.effects.executors.ConfettiEffect;
import com.xericker.mysteryboxes.core.effects.executors.FireworkShowEffect;
import com.xericker.mysteryboxes.core.effects.executors.SpiralPopperEffect;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import com.xericker.mysteryboxes.handlers.data.loots.LootStatus;
import data.FireworkData;
import data.SoundData;
import java.util.ArrayList;
import java.util.List;
import misc.EffectsParser;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class Loot {
    private FileConfiguration configFile;
    private String lootId;
    private LootStatus lootStatus;
    private static final String LOOT_CREATOR_PATH = "loot-creator.";
    private static final String EVENTS_PATH = "events-settings.loot-";
    private LootSettings lootSettings;
    private AppearanceSettings appearanceSettings;
    private DuplicatedSettings duplicateDiscovered;
    private DuplicatedSettings duplicateDuplicated;
    private EffectsSettings effectsDiscovered;
    private EffectsSettings effectsDuplicated;
    private BroadcastsSettings broadcastsDiscovered;
    private BroadcastsSettings broadcastsDuplicated;
    private CommandsSettings commandsDiscovered;
    private CommandsSettings commandsDuplicated;
    private SoundsSettings soundsDiscovered;
    private SoundsSettings soundsDuplicated;
    private FireworksSettings fireworksDiscovered;
    private FireworksSettings fireworksDuplicated;

    public Loot(String string, FileConfiguration fileConfiguration) {
        if (string.isEmpty()) {
            this.lootStatus = LootStatus.ERROR_LOOT_SETTINGS;
            return;
        }
        this.lootId = string;
        this.configFile = fileConfiguration;
        this.lootStatus = LootStatus.ENABLED;
        this.lootSettings = new LootSettings();
        if (this.lootStatus != LootStatus.ERROR_LOOT_SETTINGS && !this.getLootSettings().enabled) {
            this.lootStatus = LootStatus.DISABLED;
            return;
        }
        if (this.lootStatus == LootStatus.ERROR_LOOT_SETTINGS) {
            return;
        }
        this.appearanceSettings = new AppearanceSettings();
        this.duplicateDiscovered = new DuplicatedSettings(LootReveal.DISCOVERED);
        this.duplicateDuplicated = new DuplicatedSettings(LootReveal.DUPLICATED);
        this.effectsDiscovered = new EffectsSettings(LootReveal.DISCOVERED);
        this.effectsDuplicated = new EffectsSettings(LootReveal.DUPLICATED);
        this.broadcastsDiscovered = new BroadcastsSettings(LootReveal.DISCOVERED);
        this.broadcastsDuplicated = new BroadcastsSettings(LootReveal.DUPLICATED);
        this.commandsDiscovered = new CommandsSettings(LootReveal.DISCOVERED);
        this.commandsDuplicated = new CommandsSettings(LootReveal.DUPLICATED);
        this.soundsDiscovered = new SoundsSettings(LootReveal.DISCOVERED);
        this.soundsDuplicated = new SoundsSettings(LootReveal.DUPLICATED);
        this.fireworksDiscovered = new FireworksSettings(LootReveal.DISCOVERED);
        this.fireworksDuplicated = new FireworksSettings(LootReveal.DUPLICATED);
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public String getId() {
        return this.lootId;
    }

    public LootStatus getStatus() {
        return this.lootStatus;
    }

    public LootSettings getLootSettings() {
        return this.lootSettings;
    }

    public AppearanceSettings getAppearanceSettings() {
        return this.appearanceSettings;
    }

    public DuplicatedSettings getDuplicateSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.duplicateDiscovered : this.duplicateDuplicated;
    }

    public EffectsSettings getEffectsSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.effectsDiscovered : this.effectsDuplicated;
    }

    public CommandsSettings getCommandsSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.commandsDiscovered : this.commandsDuplicated;
    }

    public BroadcastsSettings getBroadcastsSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.broadcastsDiscovered : this.broadcastsDuplicated;
    }

    public SoundsSettings getSoundsSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.soundsDiscovered : this.soundsDuplicated;
    }

    public FireworksSettings getFireworksSettings(LootReveal lootReveal) {
        return lootReveal == LootReveal.DISCOVERED ? this.fireworksDiscovered : this.fireworksDuplicated;
    }

    public class LootSettings {
        public String name;
        public boolean enabled;
        public boolean valuable;
        public boolean dropDuplicate;

        LootSettings() {
            try {
                String string = Loot.LOOT_CREATOR_PATH + Loot.this.lootId + ".";
                this.name = ConfigParser.getString(Loot.this.configFile, string + "name");
                this.enabled = Loot.this.configFile.getBoolean(string + "enabled");
                this.valuable = Loot.this.configFile.getBoolean(string + "valuable");
                this.dropDuplicate = Loot.this.configFile.getBoolean(string + "drop-duplicate");
                if (this.name == null || this.name.isEmpty()) {
                    this.name = "\u00a7c\u26a0 The name is null";
                    Loot.this.lootStatus = LootStatus.ERROR_LOOT_SETTINGS;
                }
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_LOOT_SETTINGS;
            }
        }
    }

    public class AppearanceSettings {
        public Material type;
        public int model;
        public String head;

        AppearanceSettings() {
            try {
                String[] stringArray;
                String string = Loot.LOOT_CREATOR_PATH + Loot.this.lootId + ".";
                String string2 = Loot.this.configFile.getString(string + "box-appearance.data");
                String[] stringArray2 = stringArray = string2 != null ? string2.split(";") : null;
                if (stringArray != null) {
                    this.type = Material.matchMaterial((String)stringArray[0]);
                    this.model = Loot.this.configFile.getInt(stringArray[1]);
                }
                if (this.type == null && (this.head == null || this.head.isEmpty())) {
                    Loot.this.lootStatus = LootStatus.ERROR_BOX_APPEARANCE;
                }
                this.head = Loot.this.configFile.getString(string + "box-appearance.head");
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_BOX_APPEARANCE;
            }
        }
    }

    public class DuplicatedSettings {
        public int dustToGive;

        DuplicatedSettings(LootReveal lootReveal) {
            try {
                String string = Loot.LOOT_CREATOR_PATH + Loot.this.lootId + ".loot-" + lootReveal.name().toLowerCase() + ".";
                this.dustToGive = Loot.this.configFile.getInt(string + "dust-to-give");
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_DUPLICATE_SETTINGS;
            }
        }
    }

    public class EffectsSettings {
        public ConfettiEffect confettiEffect;
        public SpiralPopperEffect spiralPopper;
        public FireworkShowEffect fireworkShow;

        EffectsSettings(LootReveal lootReveal) {
            try {
                this.confettiEffect = new ConfettiEffect(Loot.this.configFile, lootReveal);
                if (this.confettiEffect.getStatus() == EffectStatus.INVALID) {
                    Loot.this.lootStatus = LootStatus.ERROR_EFFECTS_SETTINGS;
                }
                this.spiralPopper = new SpiralPopperEffect(Loot.this.configFile, lootReveal);
                if (this.spiralPopper.getStatus() == EffectStatus.INVALID) {
                    Loot.this.lootStatus = LootStatus.ERROR_EFFECTS_SETTINGS;
                }
                this.fireworkShow = new FireworkShowEffect(Loot.this.configFile, lootReveal);
                if (this.fireworkShow.getStatus() == EffectStatus.INVALID) {
                    Loot.this.lootStatus = LootStatus.ERROR_EFFECTS_SETTINGS;
                }
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_EFFECTS_SETTINGS;
            }
        }
    }

    public class BroadcastsSettings {
        public List<String> broadcasts;

        BroadcastsSettings(LootReveal lootReveal) {
            try {
                String string = Loot.EVENTS_PATH + lootReveal.name().toLowerCase() + ".send-broadcasts";
                this.broadcasts = new ArrayList<String>(ConfigParser.getStringList(Loot.this.configFile, string));
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_BROADCASTS_SETTINGS;
            }
        }
    }

    public class CommandsSettings {
        public boolean asPlayer;
        public List<String> commands;

        CommandsSettings(LootReveal lootReveal) {
            try {
                String string = Loot.LOOT_CREATOR_PATH + Loot.this.lootId + ".loot-" + lootReveal.name().toLowerCase() + ".";
                this.asPlayer = Loot.this.configFile.getBoolean(string + "execute-as-player");
                this.commands = new ArrayList<String>(ConfigParser.getStringList(Loot.this.configFile, string + "commands"));
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_COMMANDS_SETTINGS;
            }
        }
    }

    public class SoundsSettings {
        public List<SoundData> sounds;

        SoundsSettings(LootReveal lootReveal) {
            try {
                String string = Loot.EVENTS_PATH + lootReveal.name().toLowerCase() + ".play-sounds";
                this.sounds = new ArrayList<SoundData>();
                for (String string2 : Loot.this.configFile.getStringList(string)) {
                    this.sounds.add(EffectsParser.parseSound(string2));
                }
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_SOUNDS_SETTINGS;
            }
        }
    }

    public class FireworksSettings {
        public List<FireworkData> fireworks;

        FireworksSettings(LootReveal lootReveal) {
            try {
                String string = Loot.EVENTS_PATH + lootReveal.name().toLowerCase() + ".spawn-fireworks";
                this.fireworks = new ArrayList<FireworkData>();
                for (String string2 : Loot.this.configFile.getStringList(string)) {
                    this.fireworks.add(EffectsParser.parseFirework(string2));
                }
            }
            catch (Exception exception) {
                Loot.this.lootStatus = LootStatus.ERROR_FIREWORKS_SETTINGS;
            }
        }
    }
}

