/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.economy;

import com.xericker.mysteryboxes.Plugin;
import com.xericker.mysteryboxes.handlers.economy.EconomyAPI;
import com.xericker.mysteryboxes.handlers.economy.EconomyHandler;
import com.xericker.mysteryboxes.handlers.economy.EconomyStatus;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class EconomyInjection {
    private UUID playerId;

    public EconomyInjection(UUID uUID) {
        this.playerId = uUID;
    }

    public int getCurrency() {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.playerId);
        EconomyHandler economyHandler = Plugin.getEconomyManager();
        EconomyStatus economyStatus = economyHandler.getEconomyStatus();
        if (economyStatus == EconomyStatus.INTERNAL) {
            return 0;
        }
        if (Objects.requireNonNull(economyHandler.getEconomyAPI()) == EconomyAPI.VAULT_API) {
            return (int)economyHandler.getVaultBank().getEconomy().getBalance(offlinePlayer);
        }
        return 0;
    }

    public void setCurrency(int n) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.playerId);
        EconomyHandler economyHandler = Plugin.getEconomyManager();
        EconomyStatus economyStatus = economyHandler.getEconomyStatus();
        if (economyStatus == EconomyStatus.INTERNAL) {
            return;
        }
        if (Objects.requireNonNull(economyHandler.getEconomyAPI()) == EconomyAPI.VAULT_API) {
            economyHandler.getVaultBank().getEconomy().withdrawPlayer(offlinePlayer, (double)this.getCurrency());
            economyHandler.getVaultBank().getEconomy().depositPlayer(offlinePlayer, (double)n);
        }
    }
}

