/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus;

import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class MenuBuilder {
    protected Player player;
    protected Inventory inventory;
    protected List<Object> items;
    protected int page = 1;
    protected PlayerData playerData;
    protected MenuData menuData;

    protected MenuBuilder(Player player) {
        this.player = player;
        this.items = new ArrayList<Object>();
    }

    public void open(Player player) {
        this.playerData = PlayerDataManager.getData(player);
        this.menuData = MenuDataManager.getData(player);
        Menu menu = this.menuData.getCurrentType();
        this.inventory = Bukkit.createInventory(null, (int)(this.getRows() * 9), (String)this.getTitle());
        player.openInventory(this.inventory);
        this.menuData = MenuDataManager.getData(player);
        this.menuData.setMenu(this);
        this.menuData.setKeepData(false);
        this.menuData.setPreviousType(menu);
        this.menuData.setCurrentType(this.getMenu());
        if (this.getMenu() == Menu.VAULT) {
            this.playerData.clearGiftingData();
        }
        this.update();
    }

    public abstract void update();

    public abstract int getRows();

    public abstract String getTitle();

    public abstract Menu getMenu();

    public List<Object> getItems() {
        return this.items;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }
}

