/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.songs;

import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.files.SongPackValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.filters.FilterType;
import com.xericker.mysteryboxes.core.songpack.SongPackRequest;
import com.xericker.mysteryboxes.core.songpack.SongPlayer;
import com.xericker.mysteryboxes.handlers.data.songs.SongData;
import com.xericker.mysteryboxes.handlers.data.songs.SongManager;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.menus.menus.songs.SongsTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventSongs
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        String string;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.SONGS, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            string = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(string, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(string, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (string.equals(SongsTrigger.RESET_SONG.name())) {
                playerData.setChosenSongId(null);
                menuBuilder.update();
                MenuSound.NOTIFY.play(player);
            }
            object = null;
            if (Objects.equals(string, MenuTrigger.FILTER_ALL.name())) {
                object = FilterType.OWNED;
            } else if (Objects.equals(string, MenuTrigger.FILTER_OWNED.name())) {
                object = FilterType.UNOWNED;
            } else if (Objects.equals(string, MenuTrigger.FILTER_UNOWNED.name())) {
                object = FilterType.ALL;
            }
            if (object != null) {
                menuData.setFilterType((FilterType)((Object)object));
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (string.equals(SongsTrigger.PLAYLIST_LINK.name())) {
                player.sendMessage("\u00a7aDo you like the music? Check out my playlist on Spotify:");
                player.sendMessage("\u00a7ehttps://open.spotify.com/playlist/4Kk6aURjBAhWtXFrbd4KZw?si=0bc8e36db41d49f8");
                player.closeInventory();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (!ItemNBT.contains(itemStack, "songId")) {
            return;
        }
        string = ItemNBT.getString(itemStack, "songId");
        object = SongManager.getData(string);
        if (object == null) {
            return;
        }
        SongPackRequest songPackRequest = playerData.getSongPackRequest();
        boolean bl = songPackRequest != null && songPackRequest.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
        boolean bl2 = songPackRequest != null && songPackRequest.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED;
        boolean bl3 = songPackRequest != null && songPackRequest.getStatus() == PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD;
        boolean bl4 = ConfigParser.getBoolean(SongPackValue.PACK_ENABLED);
        if (!bl && !bl4) {
            bl = true;
        }
        if (bl2 && !bl4) {
            bl2 = false;
        }
        if (bl3 && !bl4) {
            bl3 = false;
        }
        if (!bl) {
            MenuSound.PURCHASE_FAILED.play(player);
            return;
        }
        if (inventoryClickEvent.getAction() == InventoryAction.PICKUP_HALF) {
            if (!playerData.isOnCooldown("songPreview")) {
                SongPlayer songPlayer = new SongPlayer(player, (SongData)object, 7);
                songPlayer.playSong();
                playerData.setCooldown("songPreview", TimeUnit.SECONDS, 7L);
            }
            return;
        }
        if (!((SongData)object).isUnlocked(player)) {
            if (!((SongData)object).hasPermission(player)) {
                for (String string2 : ConfigParser.getStringList(LanguageValue.GENERAL_NO_PERMISSION)) {
                    player.sendMessage(string2);
                }
                MenuSound.PURCHASE_FAILED.play(player);
                return;
            }
            if (!((SongData)object).hasDust(player)) {
                for (String string3 : ConfigParser.getStringList(LanguageValue.DUST_NOT_ENOUGH)) {
                    player.sendMessage(string3);
                }
                MenuSound.PURCHASE_FAILED.play(player);
                return;
            }
            playerData.setDust(playerData.getDust() - ((SongData)object).getUnlockSettings().dustCost);
            playerData.getSongsUnlocked().put(string, System.currentTimeMillis());
            playerData.setChosenSongId(string);
            menuBuilder.update();
            MenuSound.PURCHASE_SUCCESS.play(player);
            return;
        }
        String string4 = playerData.getChosenSongId();
        if (string4 != null && string4.equals(string)) {
            MenuSound.ERROR.play(player);
            return;
        }
        if (bl3 || bl2) {
            for (String string5 : ConfigParser.getStringList(LanguageValue.SONG_PACK_INSTALL_FAILED)) {
                player.sendMessage(string5);
            }
            MenuSound.ERROR.play(player);
            return;
        }
        playerData.setChosenSongId(string);
        menuBuilder.update();
        MenuSound.SELECT.play(player);
    }
}

