/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.upgrades;

import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.Objects;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventUpgrades
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        String string;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        if (menuData.getCurrentType() == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (!menuData.getCurrentType().validateClick(player, Menu.UPGRADES, inventoryClickEvent)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            string = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(string, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(string, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (!ItemNBT.contains(itemStack, "upgradeType")) {
            return;
        }
        string = ItemNBT.getString(itemStack, "upgradeType");
        Upgrade upgrade = Upgrade.valueOf(string);
        UpgradeData upgradeData = UpgradeManager.getData(upgrade);
        if (upgradeData == null) {
            return;
        }
        if (!(upgrade.canUpgrade(player) && upgrade.hasDust(player) && upgrade.hasPermission(player))) {
            MenuSound.PURCHASE_FAILED.play(player);
            return;
        }
        int n = playerData.getUpgrade(upgrade);
        playerData.setDust(playerData.getDust() - upgradeData.getInterface().getDustMap().get(n));
        playerData.setUpgrade(upgrade, playerData.getUpgrade(upgrade) + 1);
        menuBuilder.update();
        if (upgrade.canUpgrade(player)) {
            MenuSound.PROGRESS.play(player);
        } else {
            MenuSound.PROGRESS_MAXED.play(player);
        }
    }
}

