/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.mysql;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.mysql.SQLCredentials;
import com.xericker.mysteryboxes.mysql.SQLStatus;
import com.xericker.mysteryboxes.mysql.SQLTask;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLConnection {
    private Connection connection;
    private SQLCredentials data;
    private SQLTask task;
    private SQLStatus status;
    private long liveTime;

    public SQLStatus getStatus() {
        return this.status;
    }

    public long getLiveTime() {
        return this.liveTime;
    }

    public SQLConnection() {
        try {
            this.data = new SQLCredentials();
            if (!this.data.validateCredentials()) {
                Main.getPlugin().getLogger().warning("Failed to initialize MySQL due to invalid credentials.");
                this.status = SQLStatus.INVALID_CREDENTIALS;
                return;
            }
            if (!this.data.validateDriver()) {
                Main.getPlugin().getLogger().warning("Failed to initialize MySQL due to invalid driver.");
                this.status = SQLStatus.INVALID_DRIVER;
                return;
            }
            if (this.task == null) {
                this.task = new SQLTask();
            }
            this.status = SQLStatus.READY_TO_CONNECT;
        }
        catch (Exception exception) {
            Main.getPlugin().getLogger().warning("Failed to initialize connection.");
            exception.printStackTrace();
            this.status = SQLStatus.FAILED_TO_INITIALIZE;
        }
    }

    public void openConnection() {
        try {
            if (this.status != SQLStatus.READY_TO_CONNECT) {
                Main.getPlugin().getLogger().warning("Failed to open connection (Status is not READY_TO_CONNECT).");
                return;
            }
            String string = this.data.getPath();
            string = string.replace("{HOST}", this.data.getHost());
            string = string.replace("{PORT}", this.data.getPort());
            string = string.replace("{NAME}", this.data.getName());
            string = string.replace("{VARIABLES}", this.data.getVariables());
            String string2 = this.data.getDriver();
            Class.forName(string2);
            this.connection = DriverManager.getConnection(string, this.data.getUser(), this.data.getPass());
            this.liveTime = System.currentTimeMillis();
            this.status = SQLStatus.CONNECTED;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Main.getPlugin().getLogger().warning("Failed to load the driver class.");
            classNotFoundException.printStackTrace();
            this.status = SQLStatus.FAILED_TO_OPEN;
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to open connection.");
            sQLException.printStackTrace();
            this.status = SQLStatus.FAILED_TO_OPEN;
        }
    }

    public boolean isConnected() {
        try {
            if (this.status != SQLStatus.CONNECTED) {
                Main.getPlugin().getLogger().warning("Failed to check the connection (Status is not CONNECTED).");
                return false;
            }
            return this.connection != null && !this.connection.isClosed() && !this.connection.isReadOnly();
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to check if the connection is open.");
            sQLException.printStackTrace();
            this.status = SQLStatus.ERROR_OCCURRED;
            return false;
        }
    }

    public void closeConnection() {
        try {
            if (this.status != SQLStatus.CONNECTED) {
                Main.getPlugin().getLogger().warning("Failed to close the connection (Status is not CONNECTED).");
                return;
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
            this.status = SQLStatus.READY_TO_CONNECT;
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to close the connection.");
            sQLException.printStackTrace();
            this.status = SQLStatus.ERROR_OCCURRED;
        }
    }

    public boolean isColumnMissing(String string, String string2) {
        if (!this.isConnected()) {
            return true;
        }
        try {
            ResultSet resultSet = this.query("SHOW COLUMNS FROM `" + string + "` LIKE '" + string2 + "';");
            return resultSet == null || !resultSet.next();
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to check if a column is missing.");
            sQLException.printStackTrace();
            this.status = SQLStatus.ERROR_OCCURRED;
            return true;
        }
    }

    public ResultSet query(String string) {
        if (!this.isConnected()) {
            return null;
        }
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            return preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to execute a query.");
            sQLException.printStackTrace();
            this.status = SQLStatus.ERROR_OCCURRED;
            return null;
        }
    }

    public void update(String string) {
        if (!this.isConnected()) {
            return;
        }
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            Main.getPlugin().getLogger().warning("Failed to execute an update.");
            sQLException.printStackTrace();
            this.status = SQLStatus.ERROR_OCCURRED;
        }
    }
}

