/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.playerdata.sync.files;

import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.loots.HistoryData;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.stats.Statistic;
import com.xericker.mysteryboxes.playerdata.stats.Timestamp;
import com.xericker.mysteryboxes.playerdata.sync.DataType;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;

public class FileUtils {
    private static Object read(UUID uUID, DataType dataType, String string) {
        try {
            FileConfiguration fileConfiguration = dataType.getFile(uUID);
            if (fileConfiguration == null) {
                return null;
            }
            return fileConfiguration.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void write(UUID uUID, DataType dataType, String string, Object object) {
        try {
            FileConfiguration fileConfiguration = dataType.getFile(uUID);
            if (fileConfiguration == null) {
                return;
            }
            fileConfiguration.set(string, object);
            dataType.saveFile(uUID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Object getObject(UUID uUID, DataType dataType, String string) {
        return FileUtils.read(uUID, dataType, string);
    }

    public static void setObject(UUID uUID, DataType dataType, String string, Object object) {
        if (uUID == null || dataType == null || string == null) {
            return;
        }
        FileUtils.write(uUID, dataType, string, object);
    }

    public static int getBoxes(UUID uUID, Box box) {
        Object object = FileUtils.read(uUID, DataType.BOXES, box.getId());
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static void setBoxes(UUID uUID, Box box, int n) {
        if (n < 0) {
            n = 0;
        }
        FileUtils.write(uUID, DataType.BOXES, box.getId(), n);
    }

    public static int getGiftPacks(UUID uUID, Box box) {
        Object object = FileUtils.read(uUID, DataType.GIFTS, box.getId());
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static void setGiftPacks(UUID uUID, Box box, int n) {
        if (n < 0) {
            n = 0;
        }
        FileUtils.write(uUID, DataType.GIFTS, box.getId(), n);
    }

    public static int getDust(UUID uUID) {
        Object object = FileUtils.read(uUID, DataType.DUST, "VALUE");
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static void setDust(UUID uUID, int n) {
        if (n < 0) {
            n = 0;
        }
        FileUtils.write(uUID, DataType.DUST, "VALUE", n);
    }

    public static long getStatistic(UUID uUID, Statistic statistic) {
        Object object = FileUtils.read(uUID, DataType.STATS, statistic.name());
        if (object == null) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(object));
    }

    public static void setStatistic(UUID uUID, Statistic statistic, long l) {
        if (l < 0L) {
            l = 0L;
        }
        FileUtils.write(uUID, DataType.STATS, statistic.name(), l);
    }

    public static long getTimestamp(UUID uUID, Timestamp timestamp) {
        Object object = FileUtils.read(uUID, DataType.TIMES, timestamp.name());
        if (object == null) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(object));
    }

    public static void setTimestamp(UUID uUID, Timestamp timestamp, long l) {
        FileUtils.write(uUID, DataType.TIMES, timestamp.name(), l);
    }

    public static void readHistory(PlayerData playerData) {
        FileConfiguration fileConfiguration = DataType.HISTORY.getFile(playerData.getPlayerId());
        if (fileConfiguration == null) {
            return;
        }
        for (String string : fileConfiguration.getKeys(false)) {
            String[] stringArray;
            String string2 = fileConfiguration.getString(string);
            if (string2 == null || (stringArray = string2.split(";")).length < 3 || stringArray.length > 5) continue;
            HistoryData historyData = new HistoryData(playerData, UUID.fromString(string));
            historyData.readData(stringArray);
            playerData.getHistoryList().add(historyData);
        }
    }

    public static void writeHistory(PlayerData playerData) {
        for (HistoryData historyData : playerData.getHistoryList()) {
            String string = historyData.getAcquireTime() + ";" + historyData.getLootName() + ";" + historyData.getBoxName();
            FileUtils.setObject(playerData.getPlayerId(), DataType.HISTORY, String.valueOf(historyData.getHistoryId()), string);
        }
    }
}

