/*
 * Decompiled with CFR 0.152.
 */
package libraries.iridium;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import libraries.iridium.patterns.GradientPattern;
import libraries.iridium.patterns.Pattern;
import libraries.iridium.patterns.RainbowPattern;
import libraries.iridium.patterns.SolidPattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;

public class IridiumColorAPI {
    private static final int VERSION = IridiumColorAPI.getVersion();
    private static final boolean SUPPORTS_RGB = VERSION >= 16;
    private static final List<String> SPECIAL_COLORS = Arrays.asList("&l", "&n", "&o", "&k", "&m", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m");
    private static final Map<Color, ChatColor> COLORS = ImmutableMap.builder().put((Object)new Color(0), (Object)ChatColor.getByChar((char)'0')).put((Object)new Color(170), (Object)ChatColor.getByChar((char)'1')).put((Object)new Color(43520), (Object)ChatColor.getByChar((char)'2')).put((Object)new Color(43690), (Object)ChatColor.getByChar((char)'3')).put((Object)new Color(0xAA0000), (Object)ChatColor.getByChar((char)'4')).put((Object)new Color(0xAA00AA), (Object)ChatColor.getByChar((char)'5')).put((Object)new Color(0xFFAA00), (Object)ChatColor.getByChar((char)'6')).put((Object)new Color(0xAAAAAA), (Object)ChatColor.getByChar((char)'7')).put((Object)new Color(0x555555), (Object)ChatColor.getByChar((char)'8')).put((Object)new Color(0x5555FF), (Object)ChatColor.getByChar((char)'9')).put((Object)new Color(0x55FF55), (Object)ChatColor.getByChar((char)'a')).put((Object)new Color(0x55FFFF), (Object)ChatColor.getByChar((char)'b')).put((Object)new Color(0xFF5555), (Object)ChatColor.getByChar((char)'c')).put((Object)new Color(0xFF55FF), (Object)ChatColor.getByChar((char)'d')).put((Object)new Color(0xFFFF55), (Object)ChatColor.getByChar((char)'e')).put((Object)new Color(0xFFFFFF), (Object)ChatColor.getByChar((char)'f')).build();
    private static final List<Pattern> PATTERNS = Arrays.asList(new GradientPattern(), new SolidPattern(), new RainbowPattern());

    @Nonnull
    public static String process(@Nonnull String string) {
        for (Pattern pattern : PATTERNS) {
            string = pattern.process(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    @Nonnull
    public static List<String> process(@Nonnull Collection<String> collection) {
        return collection.stream().map(IridiumColorAPI::process).collect(Collectors.toList());
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color color) {
        return String.valueOf(SUPPORTS_RGB ? ChatColor.of((Color)color) : IridiumColorAPI.getClosestColor(color)) + string;
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color color, @Nonnull Color color2) {
        String string2 = string;
        ChatColor[] chatColorArray = IridiumColorAPI.createGradient(color, color2, IridiumColorAPI.withoutSpecialChar(string).length());
        return IridiumColorAPI.apply(string2, chatColorArray);
    }

    @Nonnull
    public static String rainbow(@Nonnull String string, float f) {
        String string2 = string;
        ChatColor[] chatColorArray = IridiumColorAPI.createRainbow(IridiumColorAPI.withoutSpecialChar(string).length(), f);
        return IridiumColorAPI.apply(string2, chatColorArray);
    }

    @Nonnull
    public static ChatColor getColor(@Nonnull String string) {
        return SUPPORTS_RGB ? ChatColor.of((Color)new Color(Integer.parseInt(string, 16))) : IridiumColorAPI.getClosestColor(new Color(Integer.parseInt(string, 16)));
    }

    @Nonnull
    public static String stripColorFormatting(@Nonnull String string) {
        return string.replaceAll("<#[0-9A-F]{6}>|[&\u00a7][a-f0-9lnokm]|<[/]?[A-Z]{5,8}(:[0-9A-F]{6})?[0-9]*>", "");
    }

    @Nonnull
    private static String apply(@Nonnull String string, ChatColor[] chatColorArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray = string.split("");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("&") || stringArray[i].equals("\u00a7")) {
                if (i + 1 < stringArray.length) {
                    if (stringArray[i + 1].equals("r")) {
                        stringBuilder.setLength(0);
                    } else {
                        stringBuilder.append(stringArray[i]);
                        stringBuilder.append(stringArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                stringBuilder2.append(chatColorArray[n++]).append((CharSequence)stringBuilder).append(stringArray[i]);
                continue;
            }
            stringBuilder2.append(chatColorArray[n++]).append((CharSequence)stringBuilder).append(stringArray[i]);
        }
        return stringBuilder2.toString();
    }

    @Nonnull
    private static String withoutSpecialChar(@Nonnull String string) {
        String string2 = string;
        for (String string3 : SPECIAL_COLORS) {
            if (!string2.contains(string3)) continue;
            string2 = string2.replace(string3, "");
        }
        return string2;
    }

    @Nonnull
    private static ChatColor[] createRainbow(int n, float f) {
        ChatColor[] chatColorArray = new ChatColor[n];
        double d = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            Color color = Color.getHSBColor((float)(d * (double)i), f, f);
            chatColorArray[i] = SUPPORTS_RGB ? ChatColor.of((Color)color) : IridiumColorAPI.getClosestColor(color);
        }
        return chatColorArray;
    }

    @Nonnull
    private static ChatColor[] createGradient(@Nonnull Color color, @Nonnull Color color2, int n) {
        ChatColor[] chatColorArray = new ChatColor[n];
        int n2 = Math.abs(color.getRed() - color2.getRed()) / (n - 1);
        int n3 = Math.abs(color.getGreen() - color2.getGreen()) / (n - 1);
        int n4 = Math.abs(color.getBlue() - color2.getBlue()) / (n - 1);
        int[] nArray = new int[]{color.getRed() < color2.getRed() ? 1 : -1, color.getGreen() < color2.getGreen() ? 1 : -1, color.getBlue() < color2.getBlue() ? 1 : -1};
        for (int i = 0; i < n; ++i) {
            Color color3 = new Color(color.getRed() + n2 * i * nArray[0], color.getGreen() + n3 * i * nArray[1], color.getBlue() + n4 * i * nArray[2]);
            chatColorArray[i] = SUPPORTS_RGB ? ChatColor.of((Color)color3) : IridiumColorAPI.getClosestColor(color3);
        }
        return chatColorArray;
    }

    @Nonnull
    private static ChatColor getClosestColor(Color color) {
        Color color2 = null;
        double d = 2.147483647E9;
        for (Color color3 : COLORS.keySet()) {
            double d2 = Math.pow(color.getRed() - color3.getRed(), 2.0) + Math.pow(color.getGreen() - color3.getGreen(), 2.0) + Math.pow(color.getBlue() - color3.getBlue(), 2.0);
            if (!(d > d2)) continue;
            color2 = color3;
            d = d2;
        }
        return COLORS.get(color2);
    }

    private static int getVersion() {
        String string = Bukkit.getVersion();
        int n = string.lastIndexOf("MC:");
        if (n != -1) {
            string = string.substring(n + 4, string.length() - 1);
        } else if (string.endsWith("SNAPSHOT")) {
            n = string.indexOf(45);
            string = string.substring(0, n);
        }
        int n2 = string.lastIndexOf(46);
        if (string.indexOf(46) != n2) {
            string = string.substring(0, n2);
        }
        return Integer.parseInt(string.substring(2));
    }
}

