/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.reflections.Store;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;
import org.reflections.util.Utils;

public class MethodParameterNamesScanner
extends AbstractScanner {
    @Override
    public void scan(Object object, Store store) {
        MetadataAdapter metadataAdapter = this.getMetadataAdapter();
        for (Object m : metadataAdapter.getMethods(object)) {
            String string = metadataAdapter.getMethodFullKey(object, m);
            if (!this.acceptResult(string)) continue;
            CodeAttribute codeAttribute = ((MethodInfo)m).getCodeAttribute();
            LocalVariableAttribute localVariableAttribute = codeAttribute != null ? (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable") : null;
            int n = localVariableAttribute != null ? localVariableAttribute.tableLength() : 0;
            int n2 = Modifier.isStatic(((MethodInfo)m).getAccessFlags()) ? 0 : 1;
            if (n2 >= n) continue;
            ArrayList<String> arrayList = new ArrayList<String>(n - n2);
            while (n2 < n) {
                arrayList.add(((MethodInfo)m).getConstPool().getUtf8Info(localVariableAttribute.nameIndex(n2++)));
            }
            this.put(store, string, Utils.join(arrayList, ", "));
        }
    }
}

