/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class UrlTypeVFS
implements Vfs.UrlType {
    public static final String[] REPLACE_EXTENSION = new String[]{".ear/", ".jar/", ".war/", ".sar/", ".har/", ".par/"};
    final String VFSZIP = "vfszip";
    final String VFSFILE = "vfsfile";
    Predicate<File> realFile = file -> file.exists() && file.isFile();

    @Override
    public boolean matches(URL uRL) {
        return "vfszip".equals(uRL.getProtocol()) || "vfsfile".equals(uRL.getProtocol());
    }

    @Override
    public Vfs.Dir createDir(URL uRL) {
        try {
            URL uRL2 = this.adaptURL(uRL);
            return new ZipDir(new JarFile(uRL2.getFile()));
        }
        catch (Exception exception) {
            try {
                return new ZipDir(new JarFile(uRL.getFile()));
            }
            catch (IOException iOException) {
                if (Reflections.log != null) {
                    Reflections.log.warn("Could not get URL", (Throwable)exception);
                    Reflections.log.warn("Could not get URL", (Throwable)iOException);
                }
                return null;
            }
        }
    }

    public URL adaptURL(URL uRL) {
        if ("vfszip".equals(uRL.getProtocol())) {
            return this.replaceZipSeparators(uRL.getPath(), this.realFile);
        }
        if ("vfsfile".equals(uRL.getProtocol())) {
            return new URL(uRL.toString().replace("vfsfile", "file"));
        }
        return uRL;
    }

    URL replaceZipSeparators(String string, Predicate<File> predicate) {
        int n = 0;
        while (n != -1) {
            File file;
            if ((n = this.findFirstMatchOfDeployableExtention(string, n)) <= 0 || !predicate.test(file = new File(string.substring(0, n - 1)))) continue;
            return this.replaceZipSeparatorStartingFrom(string, n);
        }
        throw new ReflectionsException("Unable to identify the real zip file in path '" + string + "'.");
    }

    int findFirstMatchOfDeployableExtention(String string, int n) {
        Pattern pattern = Pattern.compile("\\.[ejprw]ar/");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find(n)) {
            return matcher.end();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    URL replaceZipSeparatorStartingFrom(String string, int n) {
        void var6_8;
        String string2 = string.substring(0, n - 1);
        String string3 = string.substring(n);
        int n2 = 1;
        String[] object = REPLACE_EXTENSION;
        int n3 = object.length;
        for (int i = 0; i < n3; ++i) {
            String string4 = object[i];
            while (string3.contains(string4)) {
                string3 = string3.replace(string4, string4.substring(0, 4) + "!");
                ++n2;
            }
        }
        String string5 = "";
        for (n3 = 0; n3 < n2; ++n3) {
            String string6 = (String)var6_8 + "zip:";
        }
        if (string3.trim().length() == 0) {
            return new URL((String)var6_8 + "/" + string2);
        }
        return new URL((String)var6_8 + "/" + string2 + "!" + string3);
    }
}

