/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

public class WorldUtils {
    public static void sendChestAction(Player player, Location location, int n) {
        try {
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.BLOCK_ACTION);
            packetContainer.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            packetContainer.getIntegers().write(0, (Object)1);
            packetContainer.getIntegers().write(1, (Object)n);
            packetContainer.getBlocks().write(0, (Object)location.getBlock().getType());
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void spawnFirework(Location location, FireworkEffect.Type type, boolean bl, boolean bl2, int n, Color color, Color color2) {
        WorldUtils.spawnFirework(location, type, bl, bl2, n, Collections.singletonList(color), Collections.singletonList(color2));
    }

    public static void spawnFirework(Location location, FireworkEffect.Type type, boolean bl, boolean bl2, int n, List<Color> list, List<Color> list2) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.addEffect(FireworkEffect.builder().with(type).flicker(bl).trail(bl2).withColor(list).withFade(list2).build());
        if (n > 0) {
            fireworkMeta.setPower(n);
        }
        firework.setFireworkMeta(fireworkMeta);
        if (n == 0) {
            firework.detonate();
        }
    }

    public static void playStepSound(Location location, Material material, int n) {
        WorldUtils.playStepSound(null, location, material, n);
    }

    public static void playStepSound(Player player, Location location, Material material, int n) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        if (n <= 0) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            if (player != null) {
                player.playEffect(location, Effect.STEP_SOUND, (Object)material);
                continue;
            }
            location.getWorld().playEffect(location, Effect.STEP_SOUND, (Object)material);
        }
    }

    public static void spawnParticle(Location location, String string) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        String[] stringArray = string.split(";");
        Particle particle = Particle.valueOf((String)stringArray[0]);
        if (particle == Particle.REDSTONE) {
            int n = Integer.parseInt(stringArray[1]);
            float f = Float.parseFloat(stringArray[2]);
            String string2 = stringArray[3];
            String[] stringArray2 = string2.split(",");
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt(stringArray2[1]);
            int n4 = Integer.parseInt(stringArray2[2]);
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)n2, (int)n3, (int)n4), f);
            location.getWorld().spawnParticle(Particle.REDSTONE, location, n, (Object)dustOptions);
        } else if (particle == Particle.SPELL_MOB) {
            String string3 = stringArray[1];
            String[] stringArray3 = string3.split(",");
            int n = Integer.parseInt(stringArray3[0]);
            int n5 = Integer.parseInt(stringArray3[1]);
            int n6 = Integer.parseInt(stringArray3[2]);
            location.getWorld().spawnParticle(Particle.SPELL_MOB, location, 0, (double)n, (double)n5, (double)n6, 1.0);
        } else if (particle == Particle.DUST_COLOR_TRANSITION) {
            int n = Integer.parseInt(stringArray[1]);
            float f = Float.parseFloat(stringArray[2]);
            String string4 = stringArray[3];
            String[] stringArray4 = string4.split(",");
            int n7 = Integer.parseInt(stringArray4[0]);
            int n8 = Integer.parseInt(stringArray4[1]);
            int n9 = Integer.parseInt(stringArray4[2]);
            String string5 = stringArray[4];
            String[] stringArray5 = string5.split(",");
            int n10 = Integer.parseInt(stringArray5[0]);
            int n11 = Integer.parseInt(stringArray5[1]);
            int n12 = Integer.parseInt(stringArray5[2]);
            Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)n7, (int)n8, (int)n9), Color.fromRGB((int)n10, (int)n11, (int)n12), f);
            location.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, location, n, (Object)dustTransition);
        } else {
            int n = Integer.parseInt(stringArray[1]);
            float f = Float.parseFloat(stringArray[2]);
            float f2 = Float.parseFloat(stringArray[3]);
            float f3 = Float.parseFloat(stringArray[4]);
            float f4 = Float.parseFloat(stringArray[5]);
            location.getWorld().spawnParticle(particle, location, n, (double)f2, (double)f3, (double)f4, (double)f);
        }
    }
}

