/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.SimpleChar;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class ImageManager
extends Function {
    private final HashMap<String, SimpleChar> characterMap;
    private final CustomNameplates plugin;

    public ImageManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.characterMap = new HashMap();
    }

    @Override
    public void load() {
        if (!ConfigManager.enableImages) {
            return;
        }
        this.loadImages();
    }

    @Override
    public void unload() {
        this.characterMap.clear();
    }

    private void loadImages() {
        File[] image_config_files;
        File img_file = new File(this.plugin.getDataFolder(), "contents" + File.separator + "images");
        if (!img_file.exists() && img_file.mkdirs()) {
            this.saveDefaultImages();
        }
        if ((image_config_files = img_file.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(image_config_files, Comparator.comparing(File::getName));
        for (File image_config_file : image_config_files) {
            char img = ConfigManager.start_char;
            ConfigManager.start_char = (char)(img + '\u0001');
            String key = image_config_file.getName().substring(0, image_config_file.getName().length() - 4);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)image_config_file);
            if (!config.contains("height")) {
                config.set("height", (Object)10);
            }
            if (!config.contains("ascent")) {
                config.set("ascent", (Object)8);
            }
            if (!config.contains("width")) {
                config.set("width", (Object)10);
            }
            if (!config.contains("image")) {
                config.set("image", (Object)key);
            }
            try {
                config.save(image_config_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SimpleChar simpleChar = new SimpleChar(config.getInt("height"), config.getInt("ascent"), config.getInt("width"), img, config.getString("image") + ".png");
            this.characterMap.put(key, simpleChar);
        }
        AdventureUtils.consoleMessage("[CustomNameplates] Loaded <green>" + this.characterMap.size() + " <gray>images");
    }

    private void saveDefaultImages() {
        String[] png_list = new String[]{"bell", "bubble", "clock", "coin", "compass", "weather", "stamina_0", "stamina_1", "stamina_2"};
        String[] part_list = new String[]{".png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "images" + File.separator + name + part, false);
            }
        }
    }

    @Nullable
    public SimpleChar getImage(String key) {
        return this.characterMap.get(key);
    }

    public HashMap<String, SimpleChar> getCharacterMap() {
        return this.characterMap;
    }
}

