/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.api.CustomNameplatesAPI;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.ConditionalText;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.SimpleChar;
import net.momirealms.customnameplates.object.carrier.AbstractTextCarrier;
import net.momirealms.customnameplates.object.carrier.DisableNameplate;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import net.momirealms.customnameplates.object.carrier.TeamInfoCarrier;
import net.momirealms.customnameplates.object.carrier.TextDisplayMeta;
import net.momirealms.customnameplates.object.font.OffsetFont;
import net.momirealms.customnameplates.object.nameplate.NameplateConfig;
import net.momirealms.customnameplates.object.requirements.Requirement;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class NameplateManager
extends Function {
    private String default_nameplate;
    private String player_prefix;
    private String player_suffix;
    private String player_name_papi;
    private long preview_time;
    private DisplayMode mode;
    private boolean fakeTeam;
    private final HashMap<String, NameplateConfig> nameplateConfigMap;
    private final CustomNameplates plugin;
    private AbstractTextCarrier textCarrier;
    protected HashMap<UUID, Long> previewCoolDown = new HashMap();
    private boolean hidePrefix;
    private boolean hideSuffix;

    public NameplateManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.nameplateConfigMap = new HashMap();
    }

    @Override
    public void load() {
        if (!ConfigManager.enableNameplates) {
            return;
        }
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "nameplate.yml");
        this.loadConfig((ConfigurationSection)config);
        this.loadNameplates();
        this.loadMode((ConfigurationSection)config);
    }

    @Override
    public void unload() {
        if (this.textCarrier != null) {
            this.textCarrier.unload();
            this.textCarrier = null;
        }
        this.nameplateConfigMap.clear();
    }

    private void loadConfig(ConfigurationSection config) {
        this.default_nameplate = config.getString("default-nameplate", "none");
        this.player_name_papi = config.getString("player-name", "%player_name%");
        this.preview_time = config.getLong("preview-duration", 5L);
        this.fakeTeam = config.getBoolean("create-fake-team", true);
        this.player_prefix = config.getString("prefix", "");
        this.player_suffix = config.getString("suffix", "");
        this.hidePrefix = config.getBoolean("hide-prefix-when-equipping-nameplate", false);
        this.hideSuffix = config.getBoolean("hide-suffix-when-equipping-nameplate", false);
    }

    private void loadNameplates() {
        File[] np_config_files;
        File np_file = new File(this.plugin.getDataFolder(), "contents" + File.separator + "nameplates");
        if (!np_file.exists() && np_file.mkdirs()) {
            this.saveDefaultNameplates();
        }
        if ((np_config_files = np_file.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(np_config_files, Comparator.comparing(File::getName));
        for (File np_config_file : np_config_files) {
            char left = ConfigManager.start_char;
            char middle = (char)(ConfigManager.start_char + '\u0001');
            char right = (char)(middle + '\u0001');
            ConfigManager.start_char = (char)(right + '\u0001');
            String key = np_config_file.getName().substring(0, np_config_file.getName().length() - 4);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)np_config_file);
            if (!config.contains("display-name")) {
                config.set("display-name", (Object)key);
            }
            if (!config.contains("name-color")) {
                config.set("name-color", (Object)"white");
            }
            if (!config.contains("left.image")) {
                config.set("left.image", (Object)(key + "_left"));
            }
            if (!config.contains("left.height")) {
                config.set("left.height", (Object)16);
            }
            if (!config.contains("left.ascent")) {
                config.set("left.ascent", (Object)12);
            }
            if (!config.contains("left.width")) {
                config.set("left.width", (Object)16);
            }
            if (!config.contains("middle.image")) {
                config.set("middle.image", (Object)(key + "_middle"));
            }
            if (!config.contains("middle.height")) {
                config.set("middle.height", (Object)16);
            }
            if (!config.contains("middle.ascent")) {
                config.set("middle.ascent", (Object)12);
            }
            if (!config.contains("middle.width")) {
                config.set("middle.width", (Object)16);
            }
            if (!config.contains("right.image")) {
                config.set("right.image", (Object)(key + "_right"));
            }
            if (!config.contains("right.height")) {
                config.set("right.height", (Object)16);
            }
            if (!config.contains("right.ascent")) {
                config.set("right.ascent", (Object)12);
            }
            if (!config.contains("right.width")) {
                config.set("right.width", (Object)16);
            }
            try {
                config.save(np_config_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SimpleChar leftChar = new SimpleChar(config.getInt("left.height"), config.getInt("left.ascent"), config.getInt("left.width"), left, config.getString("left.image") + ".png");
            SimpleChar middleChar = new SimpleChar(config.getInt("middle.height"), config.getInt("middle.ascent"), config.getInt("middle.width"), middle, config.getString("middle.image") + ".png");
            SimpleChar rightChar = new SimpleChar(config.getInt("right.height"), config.getInt("right.ascent"), config.getInt("right.width"), right, config.getString("right.image") + ".png");
            ChatColor color = ChatColor.valueOf((String)Objects.requireNonNull(config.getString("color", "WHITE")).toUpperCase(Locale.ENGLISH));
            this.nameplateConfigMap.put(key, new NameplateConfig(color, config.getString("display-name"), leftChar, middleChar, rightChar));
        }
        AdventureUtils.consoleMessage("[CustomNameplates] Loaded <green>" + this.nameplateConfigMap.size() + " <gray>nameplates");
    }

    private void saveDefaultNameplates() {
        String[] png_list = new String[]{"cat", "egg", "cheems", "wither", "xmas", "halloween", "hutao", "starsky", "trident", "rabbit"};
        String[] part_list = new String[]{"_left.png", "_middle.png", "_right.png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "nameplates" + File.separator + name + part, false);
            }
        }
    }

    private void loadMode(ConfigurationSection config) {
        this.mode = DisplayMode.valueOf(config.getString("mode", "Team").toUpperCase(Locale.ENGLISH));
        if (this.mode == DisplayMode.TEAM) {
            this.textCarrier = new TeamInfoCarrier(this.plugin);
        } else if (this.mode == DisplayMode.ARMOR_STAND) {
            HashMap<ConditionalText, Double> contentMap = new HashMap<ConditionalText, Double>();
            ConfigurationSection armorStandSection = config.getConfigurationSection("armor_stand");
            if (armorStandSection != null) {
                for (String key : armorStandSection.getKeys(false)) {
                    String text = armorStandSection.getString(key + ".text");
                    double offset = armorStandSection.getDouble(key + ".vertical-offset");
                    Requirement[] requirements = ConfigUtils.getRequirements(armorStandSection.getConfigurationSection(key + ".conditions"));
                    contentMap.put(new ConditionalText(requirements, text, null), offset);
                }
            }
            this.textCarrier = new NamedEntityCarrier(this.plugin, this.mode, contentMap);
        } else if (this.mode == DisplayMode.TEXT_DISPLAY) {
            HashMap<ConditionalText, Double> contentMap = new HashMap<ConditionalText, Double>();
            ConfigurationSection textDisplaySection = config.getConfigurationSection("text_display");
            if (textDisplaySection != null) {
                for (String key : textDisplaySection.getKeys(false)) {
                    String text = textDisplaySection.getString(key + ".text");
                    double offset = textDisplaySection.getDouble(key + ".vertical-offset") + 1.2;
                    Requirement[] requirements = ConfigUtils.getRequirements(textDisplaySection.getConfigurationSection(key + ".conditions"));
                    TextDisplayMeta textDisplayMeta = ConfigUtils.getTextDisplayMeta(textDisplaySection.getConfigurationSection("options"));
                    contentMap.put(new ConditionalText(requirements, text, textDisplayMeta), offset);
                }
            }
            this.textCarrier = new NamedEntityCarrier(this.plugin, this.mode, contentMap);
        } else if (this.mode == DisplayMode.DISABLE) {
            this.textCarrier = new DisableNameplate(this.plugin);
        }
        this.plugin.getTeamManager().setTeamPacketInterface();
        if (this.textCarrier != null) {
            this.textCarrier.load();
        }
    }

    public String getNameplatePrefixWithFont(String text, NameplateConfig nameplate) {
        return ConfigManager.surroundWithFont(this.getNameplatePrefix(text, nameplate));
    }

    public String getNameplatePrefix(String text, NameplateConfig nameplate) {
        int totalWidth = this.plugin.getFontManager().getTotalPlayerNameWidth(text);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(totalWidth % 2 == 0 ? totalWidth + nameplate.left().getWidth() : totalWidth + nameplate.left().getWidth() + 1)).append(nameplate.left().getChars()).append(OffsetFont.NEG_1.getCharacter());
        int mid_amount = (totalWidth - 1) / nameplate.middle().getWidth();
        if (mid_amount == 0) {
            stringBuilder.append(nameplate.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
        } else {
            for (int i = 0; i < mid_amount; ++i) {
                stringBuilder.append(nameplate.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
            }
            stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(nameplate.middle().getWidth() - (totalWidth - 1) % nameplate.middle().getWidth()));
            stringBuilder.append(nameplate.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
        }
        stringBuilder.append(nameplate.right().getChars());
        stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(totalWidth + nameplate.right().getWidth()));
        return stringBuilder.toString();
    }

    public List<String> getAvailableNameplates(Player player) {
        ArrayList<String> nameplates = new ArrayList<String>();
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            String permission = info.getPermission().toLowerCase();
            if (!permission.startsWith("nameplates.equip.") || this.nameplateConfigMap.get(permission = permission.substring(17)) == null) continue;
            nameplates.add(permission);
        }
        return nameplates;
    }

    public boolean isInCoolDown(Player player) {
        long time = System.currentTimeMillis();
        if (time - this.previewCoolDown.getOrDefault(player.getUniqueId(), time - this.getPreview_time() * 1050L) < this.getPreview_time() * 1050L) {
            return true;
        }
        this.previewCoolDown.put(player.getUniqueId(), time);
        return false;
    }

    public void showPlayerArmorStandTags(Player player) {
        NamedEntityCarrier namedEntityCarrier = (NamedEntityCarrier)this.getTextCarrier();
        NamedEntityManager nem = namedEntityCarrier.getNamedEntityManager(player);
        nem.spawn(player);
        int i = 1;
        while ((long)i <= this.getPreview_time() * 20L) {
            this.plugin.getScheduler().runTaskAsyncLater(() -> nem.teleport(player), i);
            ++i;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> nem.destroy(player), this.getPreview_time() * 20L);
    }

    public void showPlayerArmorStandTags(Player player, String nameplate) {
        String current = this.getEquippedNameplate(player);
        if (!nameplate.equals(current)) {
            this.plugin.getDataManager().equipNameplate(player, nameplate);
            CustomNameplatesAPI.getInstance().updateNameplateTeam(player);
            this.plugin.getScheduler().runTaskAsyncLater(() -> {
                this.plugin.getDataManager().equipNameplate(player, current);
                CustomNameplatesAPI.getInstance().updateNameplateTeam(player);
            }, this.getPreview_time() * 20L);
        }
        this.showPlayerArmorStandTags(player);
    }

    public boolean existNameplate(String nameplate) {
        return this.nameplateConfigMap.containsKey(nameplate);
    }

    public AbstractTextCarrier getTextCarrier() {
        return this.textCarrier;
    }

    public HashMap<String, NameplateConfig> getNameplateConfigMap() {
        return this.nameplateConfigMap;
    }

    public boolean isFakeTeam() {
        return this.fakeTeam;
    }

    public DisplayMode getMode() {
        return this.mode;
    }

    public String getEquippedNameplate(Player player) {
        return this.plugin.getDataManager().getEquippedNameplate(player);
    }

    public String getDefault_nameplate() {
        return this.default_nameplate;
    }

    public String getPrefix() {
        return this.player_prefix;
    }

    public String getSuffix() {
        return this.player_suffix;
    }

    public NameplateConfig getNameplateConfig(String nameplate) {
        return this.nameplateConfigMap.get(nameplate);
    }

    public String getPlayerNamePapi() {
        return this.player_name_papi;
    }

    public long getPreview_time() {
        return this.preview_time;
    }

    public boolean isPrefixHidden() {
        return this.hidePrefix;
    }

    public boolean isSuffixHidden() {
        return this.hideSuffix;
    }
}

