/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.actionbar;

import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.ScoreComponent;
import net.momirealms.customnameplates.object.DynamicText;
import net.momirealms.customnameplates.object.requirements.Requirement;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.entity.Player;

public class ActionBarSender {
    private final Player player;
    private final int switch_interval;
    private int timer;
    private int current_text_id;
    private final DynamicText[] dynamicTexts;
    private final Requirement[] requirements;

    public ActionBarSender(int switch_interval, String[] texts, Requirement[] requirements, Player player) {
        this.player = player;
        this.switch_interval = switch_interval;
        this.requirements = requirements;
        this.dynamicTexts = new DynamicText[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            this.dynamicTexts[i] = new DynamicText(player, texts[i]);
        }
        this.current_text_id = 0;
    }

    public boolean canSend() {
        for (Requirement requirement : this.requirements) {
            if (requirement.isConditionMet(this.player)) continue;
            return false;
        }
        return true;
    }

    public void send() {
        ++this.timer;
        if (this.timer >= this.switch_interval) {
            this.timer = 0;
            ++this.current_text_id;
            if (this.current_text_id >= this.dynamicTexts.length) {
                this.current_text_id = 0;
            }
        }
        this.dynamicTexts[this.current_text_id].update();
        ScoreComponent.Builder builder = Component.score().name("nameplates").objective("actionbar");
        builder.append(AdventureUtils.getComponentFromMiniMessage(this.dynamicTexts[this.current_text_id].getLatestValue()));
        AdventureUtils.playerActionbar(this.player, (Component)builder.build());
    }
}

