/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.bossbar;

import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.bossbar.BossBarConfig;
import net.momirealms.customnameplates.object.bossbar.BossBarSender;
import net.momirealms.customnameplates.object.scheduler.TimerTask;
import org.bukkit.entity.Player;

public class BossBarTask {
    private TimerTask timerTask;
    private final BossBarSender[] bossBarSenders;

    public BossBarTask(Player player, BossBarConfig[] configs) {
        this.bossBarSenders = new BossBarSender[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            BossBarConfig bossBarConfig = configs[i];
            this.bossBarSenders[i] = new BossBarSender(bossBarConfig.interval(), bossBarConfig.refreshRate(), bossBarConfig.texts(), bossBarConfig.conditions(), bossBarConfig.overlay(), bossBarConfig.color(), player);
        }
    }

    public void stop() {
        if (this.timerTask != null && !this.timerTask.isCancelled()) {
            this.timerTask.cancel();
        }
        for (BossBarSender bossBarSender : this.bossBarSenders) {
            bossBarSender.hide();
        }
    }

    public void start() {
        this.timerTask = CustomNameplates.getInstance().getScheduler().runTaskAsyncTimer(() -> {
            for (BossBarSender bossBarSender : this.bossBarSenders) {
                if (!bossBarSender.canSend()) {
                    if (!bossBarSender.isShown()) continue;
                    bossBarSender.hide();
                    return;
                }
                if (bossBarSender.isShown()) {
                    bossBarSender.update();
                    continue;
                }
                bossBarSender.show();
            }
        }, 1L, 1L);
    }
}

