/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.object.ConditionalText;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.DynamicText;
import net.momirealms.customnameplates.object.carrier.NamedEntity;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityImpl;
import org.bukkit.entity.Player;

public class NamedEntityManager {
    private final ConcurrentHashMap<UUID, NamedEntity> namedEntities = new ConcurrentHashMap();
    private NamedEntity[] namedEntityArray;
    private final Set<Player> nearbyPlayers;
    private final Player owner;
    private double hatOffset;
    private final NamedEntityCarrier namedEntityCarrier;
    private double highestTextHeight;

    public NamedEntityManager(NamedEntityCarrier namedEntityCarrier, Player owner) {
        this.owner = owner;
        this.nearbyPlayers = Collections.synchronizedSet(new HashSet());
        this.namedEntityArray = new NamedEntityImpl[0];
        this.namedEntityCarrier = namedEntityCarrier;
        this.init();
    }

    public void init() {
        Set<Map.Entry<ConditionalText, Double>> entries = this.namedEntityCarrier.getPersistentText().entrySet();
        for (Map.Entry<ConditionalText, Double> entry : entries) {
            this.addNamedEntity(UUID.randomUUID(), new NamedEntityImpl(this, this.owner, new DynamicText(this.owner, entry.getKey().text()), entry.getValue(), entry.getKey().requirements(), entry.getKey().textDisplayMeta()));
        }
    }

    public void addNamedEntity(UUID uuid, NamedEntity namedEntity) {
        this.namedEntities.put(uuid, namedEntity);
        this.namedEntityArray = this.namedEntities.values().toArray(new NamedEntity[0]);
        for (Player p : this.nearbyPlayers) {
            namedEntity.spawn(p);
        }
    }

    public boolean isNearby(Player viewer) {
        return this.nearbyPlayers.contains(viewer);
    }

    public void spawn(Player viewer) {
        this.nearbyPlayers.add(viewer);
        for (NamedEntity fakeArmorStand : this.namedEntityArray) {
            if (!fakeArmorStand.canShow()) continue;
            fakeArmorStand.spawn(viewer);
        }
    }

    public void spawn() {
        for (Player player : this.nearbyPlayers) {
            this.spawn(player);
        }
    }

    public void refresh(boolean force) {
        this.highestTextHeight = -2.0;
        for (NamedEntity fakeArmorStand : this.namedEntityArray) {
            boolean canShow = fakeArmorStand.canShow();
            if (!canShow) {
                if (!fakeArmorStand.isShown()) continue;
                fakeArmorStand.destroy();
                continue;
            }
            if (fakeArmorStand.isShown()) {
                if (fakeArmorStand.getDynamicText() != null && (fakeArmorStand.getDynamicText().update() || force)) {
                    fakeArmorStand.refresh();
                }
            } else {
                fakeArmorStand.spawn();
            }
            this.highestTextHeight = Math.max(fakeArmorStand.getOffset(), this.highestTextHeight);
        }
    }

    public void destroy() {
        for (NamedEntity entity : this.namedEntityArray) {
            entity.destroy();
        }
        this.nearbyPlayers.clear();
    }

    public void teleport(Player viewer) {
        for (NamedEntity entity : this.namedEntityArray) {
            if (!entity.isShown()) continue;
            entity.teleport(viewer);
        }
    }

    public void move(Player viewer, short x, short y, short z, boolean onGround) {
        for (NamedEntity entity : this.namedEntityArray) {
            if (!entity.isShown()) continue;
            entity.move(viewer, x, y, z, onGround);
        }
    }

    public void teleport() {
        for (NamedEntity entity : this.namedEntityArray) {
            if (!entity.isShown()) continue;
            entity.teleport();
        }
    }

    public void setSneak(boolean sneaking, boolean respawn) {
        for (NamedEntity entity : this.namedEntityArray) {
            if (!entity.isShown()) continue;
            entity.setSneak(sneaking, respawn);
        }
    }

    public void respawn() {
        for (NamedEntity entity : this.namedEntityArray) {
            if (!entity.isShown()) continue;
            for (Player viewer : this.nearbyPlayers) {
                entity.respawn(viewer);
            }
        }
    }

    public void destroy(Player viewer) {
        for (NamedEntity entity : this.namedEntityArray) {
            entity.destroy(viewer);
        }
        this.unregisterPlayer(viewer);
    }

    public void unregisterPlayer(Player viewer) {
        this.nearbyPlayers.remove(viewer);
    }

    public void removeArmorStand(UUID uuid) {
        NamedEntity entity = this.namedEntities.remove(uuid);
        if (entity != null) {
            entity.destroy();
            this.namedEntityArray = this.namedEntities.values().toArray(new NamedEntity[0]);
        }
    }

    public void ascent(double lineSpace) {
        for (NamedEntity entity : this.namedEntityArray) {
            entity.setOffset(entity.getOffset() + lineSpace);
            entity.teleport();
        }
    }

    public double getHatOffset() {
        return this.hatOffset;
    }

    public void setHatOffset(double hatOffset) {
        this.hatOffset = hatOffset;
        this.teleport();
    }

    public DisplayMode getDisplayMode() {
        return this.namedEntityCarrier.getDisplayMode();
    }

    public double getHighestTextHeight() {
        return this.highestTextHeight;
    }

    public Collection<Player> getNearbyPlayers() {
        return this.nearbyPlayers;
    }
}

