/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.List;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.listener.packet.EntityDestroyListener;
import net.momirealms.customnameplates.listener.packet.EntityLookListener;
import net.momirealms.customnameplates.listener.packet.EntityMoveListener;
import net.momirealms.customnameplates.listener.packet.EntitySpawnListener;
import net.momirealms.customnameplates.listener.packet.EntityTeleportListener;
import net.momirealms.customnameplates.object.carrier.AbstractPacketsHandler;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import org.bukkit.entity.Player;

public class NamedEntityPacketsHandler
extends AbstractPacketsHandler {
    private final NamedEntityCarrier namedEntityCarrier;
    private final EntityDestroyListener entityDestroyListener;
    private final EntityMoveListener entityMoveListener;
    private final EntitySpawnListener entitySpawnListener;
    private final EntityTeleportListener entityTeleportListener;
    private final EntityLookListener entityLookListener;

    public NamedEntityPacketsHandler(NamedEntityCarrier namedEntityCarrier) {
        this.namedEntityCarrier = namedEntityCarrier;
        this.entityDestroyListener = new EntityDestroyListener(this);
        this.entityMoveListener = new EntityMoveListener(this);
        this.entitySpawnListener = new EntitySpawnListener(this);
        this.entityTeleportListener = new EntityTeleportListener(this);
        this.entityLookListener = new EntityLookListener(this);
    }

    @Override
    public void load() {
        super.load();
        CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.entityDestroyListener);
        CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.entityMoveListener);
        CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.entitySpawnListener);
        CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.entityTeleportListener);
        CustomNameplates.getProtocolManager().addPacketListener((PacketListener)this.entityLookListener);
    }

    @Override
    public void unload() {
        super.unload();
        CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.entityDestroyListener);
        CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.entityMoveListener);
        CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.entitySpawnListener);
        CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.entityTeleportListener);
        CustomNameplates.getProtocolManager().removePacketListener((PacketListener)this.entityLookListener);
    }

    @Override
    public void onEntityMove(Player receiver, int entityId, short x, short y, short z, boolean onGround) {
        Player mover = super.getPlayerFromMap(entityId);
        if (mover != null) {
            this.namedEntityCarrier.getNamedEntityManager(mover).move(receiver, x, y, z, onGround);
        }
    }

    @Override
    public void onEntityTeleport(Player receiver, int entityId) {
        Player teleporter = super.getPlayerFromMap(entityId);
        if (teleporter != null) {
            this.namedEntityCarrier.getNamedEntityManager(teleporter).teleport(receiver);
        }
    }

    @Override
    public void onEntitySpawn(Player receiver, int entityId, PacketEvent event) {
        NamedEntityManager nem;
        Player spawnedPlayer = super.getPlayerFromMap(entityId);
        if (spawnedPlayer != null && (nem = this.namedEntityCarrier.getNamedEntityManager(spawnedPlayer)) != null) {
            nem.spawn(receiver);
        }
    }

    @Override
    public void onEntityDestroy(Player receiver, List<Integer> entities) {
        for (int entity : entities) {
            this.onEntityDestroy(receiver, entity);
        }
    }

    @Override
    public void onEntityDestroy(Player receiver, int entity) {
        Player deSpawnedPlayer = super.getPlayerFromMap(entity);
        if (deSpawnedPlayer != null) {
            this.namedEntityCarrier.getNamedEntityManager(deSpawnedPlayer).destroy(receiver);
        }
    }
}

