/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.utils;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ArmorStandUtils {
    public static void preview(Component component, Player player, int duration) {
        int id = new Random().nextInt(Integer.MAX_VALUE);
        ArmorStandUtils.sendSpawnPacket(player, id);
        ArmorStandUtils.sendMetaPacket(player, id, component);
        for (int i = 1; i < duration * 20 - 1; ++i) {
            CustomNameplates.getInstance().getScheduler().runTaskAsyncLater(() -> ArmorStandUtils.sendTeleportPacket(player, id), i);
        }
        CustomNameplates.getInstance().getScheduler().runTaskAsyncLater(() -> ArmorStandUtils.sendDestroyPacket(player, id), (long)duration * 20L);
    }

    public static void sendSpawnPacket(Player player, int id) {
        PacketContainer spawnPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        spawnPacket.getModifier().write(0, (Object)id);
        spawnPacket.getModifier().write(1, (Object)UUID.randomUUID());
        spawnPacket.getEntityTypeModifier().write(0, (Object)EntityType.ARMOR_STAND);
        Location location = player.getLocation();
        spawnPacket.getDoubles().write(0, (Object)location.getX());
        spawnPacket.getDoubles().write(1, (Object)(location.getY() + 0.8));
        spawnPacket.getDoubles().write(2, (Object)location.getZ());
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, spawnPacket);
    }

    public static void sendMetaPacket(Player player, int id, Component component) {
        PacketContainer metaPacket = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer1 = WrappedDataWatcher.Registry.get(Boolean.class);
        WrappedDataWatcher.Serializer serializer2 = WrappedDataWatcher.Registry.get(Byte.class);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true)), Optional.of(WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(component))).getHandle()));
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, serializer1), (Object)true);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(5, serializer1), (Object)true);
        byte mask1 = 32;
        byte mask2 = 1;
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(0, serializer2), (Object)mask1);
        wrappedDataWatcher.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(15, serializer2), (Object)mask2);
        metaPacket.getModifier().write(0, (Object)id);
        if (CustomNameplates.getInstance().getVersionHelper().isVersionNewerThan1_19_R2()) {
            ArrayList wrappedDataValueList = Lists.newArrayList();
            wrappedDataWatcher.getWatchableObjects().stream().filter(Objects::nonNull).forEach(entry -> {
                WrappedDataWatcher.WrappedDataWatcherObject dataWatcherObject = entry.getWatcherObject();
                wrappedDataValueList.add(new WrappedDataValue(dataWatcherObject.getIndex(), dataWatcherObject.getSerializer(), entry.getRawValue()));
            });
            metaPacket.getDataValueCollectionModifier().write(0, (Object)wrappedDataValueList);
        } else {
            metaPacket.getWatchableCollectionModifier().write(0, (Object)wrappedDataWatcher.getWatchableObjects());
        }
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, metaPacket);
    }

    public static void sendTeleportPacket(Player player, int id) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)id);
        Location location = player.getLocation();
        packet.getDoubles().write(0, (Object)location.getX());
        packet.getDoubles().write(1, (Object)(location.getY() + 0.8));
        packet.getDoubles().write(2, (Object)location.getZ());
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void sendDestroyPacket(Player player, int id) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntLists().write(0, List.of(Integer.valueOf(id)));
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }
}

