/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.bossbar;

import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.bossbar.CurrentBossBar;
import com.ehhthan.happyhud.comp.protocollib.wrapper.WrapperPlayServerBoss;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.plugin.Plugin;

public class BossBarHandler {
    public static final Supplier<WrapperPlayServerBoss.WrappedBossBarAddOperation> BLANK = () -> WrapperPlayServerBoss.WrappedBossBarAddOperation.create(WrappedChatComponent.fromText((String)""), 0.0f, BarColor.valueOf((String)HappyHUD.getInstance().getConfig().getString("boss-bar.color", "yellow").toUpperCase(Locale.ROOT)), BarStyle.SOLID, false, false, false);
    private final HudHolder holder;
    private final UUID handlerId = UUID.randomUUID();
    private final int maxHandled;
    private final LinkedList<UUID> ids;
    private final Map<UUID, CurrentBossBar> mappedWrappers = new LinkedHashMap<UUID, CurrentBossBar>();
    private final int position;

    public BossBarHandler(HudHolder hudHolder) {
        this.holder = hudHolder;
        this.position = HappyHUD.getInstance().getConfig().getInt("boss-bar.hud-position", 4) - 1;
        this.maxHandled = HappyHUD.getInstance().getConfig().getInt("boss-bar.max", 7);
        this.ids = new LinkedList();
        for (int i = 0; i < this.maxHandled; ++i) {
            this.ids.add(UUID.randomUUID());
        }
    }

    public void init() {
        LinkedList<UUID> linkedList = new LinkedList<UUID>(this.ids);
        linkedList.add(this.position, this.handlerId);
        for (UUID uUID : linkedList) {
            WrapperPlayServerBoss wrapperPlayServerBoss = new WrapperPlayServerBoss();
            wrapperPlayServerBoss.setId(uUID);
            wrapperPlayServerBoss.setOperation(BLANK.get());
            wrapperPlayServerBoss.sendPacket(this.holder.player());
        }
    }

    public void disable() {
        LinkedList<UUID> linkedList = new LinkedList<UUID>(this.ids);
        linkedList.add(this.position, this.handlerId);
        for (UUID uUID : linkedList) {
            WrapperPlayServerBoss wrapperPlayServerBoss = new WrapperPlayServerBoss();
            wrapperPlayServerBoss.setId(uUID);
            wrapperPlayServerBoss.setOperation(WrapperPlayServerBoss.WrappedBossBarRemoveOperation.create());
            wrapperPlayServerBoss.sendPacket(this.holder.player());
        }
    }

    public void update() {
        int n = 0;
        LinkedList<CurrentBossBar> linkedList = new LinkedList<CurrentBossBar>(this.mappedWrappers.values());
        for (UUID uUID : this.ids) {
            WrapperPlayServerBoss wrapperPlayServerBoss = new WrapperPlayServerBoss();
            wrapperPlayServerBoss.setId(uUID);
            if (linkedList.size() > n) {
                wrapperPlayServerBoss.setOperation(((CurrentBossBar)linkedList.get(n)).get());
            } else {
                wrapperPlayServerBoss.setOperation(BLANK.get());
            }
            wrapperPlayServerBoss.sendPacket(this.holder.player());
            ++n;
        }
    }

    public LinkedList<UUID> getIds() {
        return this.ids;
    }

    public void setHud(WrappedChatComponent wrappedChatComponent) {
        WrapperPlayServerBoss wrapperPlayServerBoss = new WrapperPlayServerBoss();
        wrapperPlayServerBoss.setId(this.handlerId);
        wrapperPlayServerBoss.setOperation(WrapperPlayServerBoss.WrappedBossBarUpdateNameOperation.create(wrappedChatComponent));
        wrapperPlayServerBoss.sendPacket(this.holder.player());
    }

    public void send(WrapperPlayServerBoss wrapperPlayServerBoss) {
        WrapperPlayServerBoss.WrappedBossBarOperation wrappedBossBarOperation;
        UUID uUID = wrapperPlayServerBoss.getId();
        if (this.mappedWrappers.containsKey(uUID)) {
            if (wrapperPlayServerBoss.getOperation().getType() == WrapperPlayServerBoss.OperationType.REMOVE) {
                this.mappedWrappers.remove(uUID);
            } else {
                this.mappedWrappers.get(uUID).merge(wrapperPlayServerBoss.getOperation());
            }
        } else if (this.mappedWrappers.size() < this.maxHandled && (wrappedBossBarOperation = wrapperPlayServerBoss.getOperation()) instanceof WrapperPlayServerBoss.WrappedBossBarAddOperation) {
            WrapperPlayServerBoss.WrappedBossBarAddOperation wrappedBossBarAddOperation = (WrapperPlayServerBoss.WrappedBossBarAddOperation)wrappedBossBarOperation;
            this.mappedWrappers.put(uUID, new CurrentBossBar(wrappedBossBarAddOperation));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)HappyHUD.getInstance(), this::update, 1L);
    }

    public boolean isHolding(UUID uUID) {
        return this.ids.contains(uUID) || this.handlerId == uUID;
    }
}

