/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.element.layout;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.element.ElementHolder;
import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;

public class HudLayout
implements ElementHolder {
    private final String key;
    private final List<HudElement> elements;

    public HudLayout(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("elements"), (Object)"No elements are defined.");
        LinkedList<HudElement> linkedList = new LinkedList<HudElement>();
        for (String string : configurationSection.getConfigurationSection("elements").getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("elements." + string);
            if (configurationSection2 == null) continue;
            try {
                linkedList.add(new HudElement(configurationSection2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HappyHUD.getInstance().getLogger().log(Level.WARNING, String.format("Could not load element '%s' from layout '%s': %s", string, this.key, illegalArgumentException.getMessage()));
            }
        }
        this.elements = Lists.reverse(linkedList);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<HudElement> getElements() {
        return this.elements;
    }

    @Override
    public String getType() {
        return "layout";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HudLayout hudLayout = (HudLayout)object;
        return Objects.equals(this.key, hudLayout.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

