/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.active.element;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.ehhthan.happyhud.api.element.popup.HudPopup;
import com.ehhthan.happyhud.api.hud.active.element.AbstractActiveElementHolder;
import com.ehhthan.happyhud.api.hud.active.element.ActiveElement;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ActivePopup
extends AbstractActiveElementHolder<HudPopup> {
    private final List<HudElement> elements;
    private final List<TimedActiveElement> active;
    private Component component;

    public ActivePopup(HudHolder hudHolder, HudPopup hudPopup) {
        super(hudHolder, hudPopup);
        this.elements = hudPopup.getElements();
        this.active = new LinkedList<TimedActiveElement>();
        this.update(new LayerListener[0]);
    }

    public void add(int n, String ... stringArray) {
        if (((HudPopup)this.getParent()).isRequireUnique()) {
            for (TimedActiveElement timedActiveElement : this.active) {
                if (!Arrays.equals(stringArray, timedActiveElement.args)) continue;
                return;
            }
        }
        this.active.add(0, new TimedActiveElement(n, stringArray));
        this.build();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean update(LayerListener ... layerListenerArray) {
        boolean bl = false;
        for (TimedActiveElement timedActiveElement : this.active) {
            if (!timedActiveElement.activeElement.update(layerListenerArray)) continue;
            bl = true;
        }
        if (bl) {
            this.build();
        }
        return bl;
    }

    @Override
    public void build() {
        if (this.active.isEmpty()) {
            this.getHolder().removePopup(this);
            return;
        }
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < this.active.size() && i < this.elements.size(); ++i) {
            ActiveElement activeElement = this.active.get(i).getActiveElement(i);
            if (activeElement.getConditionResult().isHidden()) continue;
            builder.append(activeElement.getComponent());
        }
        this.component = builder.build();
    }

    private ActivePopup instance() {
        return this;
    }

    class TimedActiveElement {
        private final String[] args;
        private int slot = -1;
        private ActiveElement activeElement;

        public TimedActiveElement(int n, String ... stringArray) {
            this.args = stringArray;
            Bukkit.getScheduler().runTaskLater((Plugin)HappyHUD.getInstance(), () -> {
                if (ActivePopup.this.active.contains(this)) {
                    ActivePopup.this.active.remove(this);
                    ActivePopup.this.build();
                }
            }, (long)n);
        }

        public ActiveElement getActiveElement(int n) {
            if (this.slot != n) {
                this.slot = n;
                this.activeElement = new ActiveElement(ActivePopup.this.instance(), ActivePopup.this.elements.get(n), this.args);
            }
            return this.activeElement;
        }
    }
}

