/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.active.layer;

import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.active.layer.ActiveLayer;
import com.ehhthan.happyhud.api.hud.condition.ConditionHolder;
import com.ehhthan.happyhud.api.hud.layer.Functional;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.hud.layer.type.texture.TextureLayer;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.format.TextColor;
import java.util.Arrays;

public abstract class AbstractActiveLayer<T extends HudLayer>
implements ActiveLayer<T> {
    private final HudHolder holder;
    private final T layer;
    private final LayerListener listener;
    private Component component;
    private ConditionHolder.ConditionResult conditionResult;

    public AbstractActiveLayer(HudHolder hudHolder, T t) {
        LayerListener layerListener;
        this.holder = hudHolder;
        this.layer = t;
        if (t instanceof Functional) {
            Functional functional = (Functional)t;
            layerListener = functional.getListener();
        } else {
            layerListener = null;
        }
        this.listener = layerListener;
    }

    @Override
    public HudHolder getHolder() {
        return this.holder;
    }

    @Override
    public T getLayer() {
        return this.layer;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ConditionHolder.ConditionResult getConditionResult() {
        return this.conditionResult;
    }

    public boolean updateConditions() {
        ConditionHolder.ConditionResult conditionResult = this.layer.getConditions().result(this.holder);
        if (conditionResult != this.conditionResult) {
            this.conditionResult = conditionResult;
            return true;
        }
        return false;
    }

    public boolean isListener(LayerListener ... layerListenerArray) {
        return this.listener == null || layerListenerArray.length == 0 || Arrays.asList(layerListenerArray).contains(this.listener);
    }

    @Override
    public void build() {
        TextColor textColor = null;
        if (this.conditionResult.hasColor()) {
            textColor = this.conditionResult.getColor();
        } else {
            T t = this.layer;
            if (t instanceof TextureLayer) {
                TextureLayer textureLayer = (TextureLayer)t;
                textColor = textureLayer.getColor();
            }
        }
        this.component = this.layer.getAlignment().align(this.getSizedComponent()).color(textColor);
    }
}

