/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer;

import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.condition.ConditionHolder;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.LayerScale;
import com.ehhthan.happyhud.api.hud.util.HudAlignment;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public abstract class AbstractHudLayer
implements HudLayer {
    private final String key;
    private final HudAsset asset;
    private final LayerScale scale;
    private final OffsetPosition offset;
    private final HudAlignment alignment;
    private final boolean outlined;
    private final ConditionHolder conditions;

    protected AbstractHudLayer(HudAsset hudAsset, ConfigurationSection configurationSection, int n) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        this.asset = hudAsset;
        boolean bl = configurationSection.getBoolean("options.scale-offset", false);
        this.scale = configurationSection.isConfigurationSection("scale") ? new LayerScale(configurationSection.getDouble("scale.x", 1.0), configurationSection.getDouble("scale.y", 1.0), bl) : new LayerScale(configurationSection.getDouble("scale", 1.0), bl);
        this.offset = new OffsetPosition(configurationSection.getInt("offset.x", 0), configurationSection.getInt("offset.y", 0), n);
        this.alignment = HudAlignment.valueOf(configurationSection.getString("align", "RIGHT").toUpperCase(Locale.ROOT));
        this.outlined = configurationSection.getBoolean("outlined", false);
        this.conditions = new ConditionHolder(hudAsset, configurationSection.getStringList("conditions"));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public HudAsset getAsset() {
        return this.asset;
    }

    @Override
    public LayerScale getScale() {
        return this.scale;
    }

    @Override
    public boolean isScale() {
        return this.scale != LayerScale.UNSCALED;
    }

    @Override
    public OffsetPosition getOffset() {
        return this.offset;
    }

    @Override
    public HudAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public boolean isOutlined() {
        return this.outlined;
    }

    @Override
    public ConditionHolder getConditions() {
        return this.conditions;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractHudLayer abstractHudLayer = (AbstractHudLayer)object;
        return this.isOutlined() == abstractHudLayer.isOutlined() && this.getKey().equals(abstractHudLayer.getKey()) && this.getAsset().equals(abstractHudLayer.getAsset()) && this.getOffset().equals(abstractHudLayer.getOffset()) && this.getAlignment() == abstractHudLayer.getAlignment() && this.getConditions().equals(abstractHudLayer.getConditions());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getKey(), this.getAsset(), this.getOffset(), this.getAlignment(), this.isOutlined(), this.getConditions()});
    }
}

