/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer.listener;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.util.MathUtil;
import com.google.common.base.Function;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class PlaceholderListener
implements LayerListener {
    private final String key;
    private final String value;
    private final String max;
    private final Map<String, Function<HudHolder, String>> placeholders;

    public PlaceholderListener(ConfigurationSection configurationSection) {
        this.key = configurationSection.getName().toLowerCase(Locale.ROOT);
        this.value = configurationSection.getString("value", "0");
        this.max = configurationSection.getString("max", "0");
        this.placeholders = Map.of("value", hudHolder -> MathUtil.toFormatted(this.getValue((HudHolder)hudHolder)), "max", hudHolder -> MathUtil.toFormatted(this.getMax((HudHolder)hudHolder)), "percent", hudHolder -> MathUtil.toFormatted(this.getCoefficient((HudHolder)hudHolder)));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Function<HudHolder, String>> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public double getValue(HudHolder hudHolder) {
        Optional<Double> optional = MathUtil.toDouble(HappyHUD.getInstance().parsers().parse(hudHolder, this.value));
        return optional.isPresent() ? optional.get() : 0.0;
    }

    @Override
    public double getMax(HudHolder hudHolder) {
        Optional<Double> optional = MathUtil.toDouble(HappyHUD.getInstance().parsers().parse(hudHolder, this.max));
        return optional.isPresent() ? optional.get() : 0.0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlaceholderListener placeholderListener = (PlaceholderListener)object;
        if (!this.key.equals(placeholderListener.key)) {
            return false;
        }
        if (!this.value.equals(placeholderListener.value)) {
            return false;
        }
        return this.max.equals(placeholderListener.max);
    }

    public int hashCode() {
        int n = this.key.hashCode();
        n = 31 * n + this.value.hashCode();
        n = 31 * n + this.max.hashCode();
        return n;
    }
}

