/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer.type.text;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.layer.AbstractHudLayer;
import com.ehhthan.happyhud.api.hud.layer.type.text.TextLayer;
import com.ehhthan.happyhud.api.resourcepack.asset.font.PackFont;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public class AbstractTextLayer
extends AbstractHudLayer
implements TextLayer {
    private final String text;
    private final PackFont font;

    protected AbstractTextLayer(HudAsset hudAsset, ConfigurationSection configurationSection, int n) {
        super(hudAsset, configurationSection, n);
        Preconditions.checkArgument((boolean)configurationSection.isSet("text"), (Object)"No text has been defined.");
        this.text = configurationSection.getString("text");
        this.font = HappyHUD.getInstance().fonts().get(configurationSection.getString("font", "default"));
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public PackFont getFont() {
        return this.font;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractTextLayer abstractTextLayer = (AbstractTextLayer)object;
        return Objects.equals(this.getText(), abstractTextLayer.getText()) && Objects.equals(this.getFont(), abstractTextLayer.getFont());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getText(), this.getFont());
    }
}

