/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.asset.position;

import com.ehhthan.happyhud.api.hud.layer.LayerScale;
import com.ehhthan.happyhud.api.resourcepack.asset.position.PositionContainer;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ScreenPosition;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ShaderInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class PositionCase {
    private final ScreenPosition position;
    private final boolean outlined;
    private final LayerScale scale;
    private final List<String> lines = new LinkedList<String>();

    public PositionCase(ShaderInfo shaderInfo) {
        this.position = shaderInfo.getPosition();
        this.outlined = shaderInfo.isOutlined();
        this.scale = shaderInfo.getScale();
        int n = this.position.getOffset().getX();
        int n2 = this.position.getOffset().getY();
        if (this.scale != LayerScale.UNSCALED) {
            double d = this.scale.getX();
            double d2 = this.scale.getY();
            if (d != 1.0) {
                this.lines.add(PositionContainer.getTabs(4) + "scale.x = " + d + ";");
            }
            if (d2 != 1.0) {
                this.lines.add(PositionContainer.getTabs(4) + "scale.y = " + d2 + ";");
            }
        }
        this.lines.add(this.getPositionLine('x', this.position.getRelativeX() * -1.0f, n * -1));
        this.lines.add(this.getPositionLine('y', this.position.getRelativeY(), n2));
        this.lines.add(PositionContainer.getTabs(4) + "layer = " + this.position.getOffset().getZ() + ";");
        if (this.outlined) {
            this.lines.add(PositionContainer.getTabs(4) + "outlined = true;");
        }
    }

    public ScreenPosition getPosition() {
        return this.position;
    }

    public List<String> getLines() {
        return this.lines;
    }

    private String getPositionLine(char c, double d, int n) {
        StringBuilder stringBuilder = new StringBuilder(PositionContainer.getTabs(4)).append(String.format("%cOffset = int(guiSize.%<c * (%.1f/100))", Character.valueOf(c), d).replace(',', '.'));
        if (n != 0) {
            if (n > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PositionCase positionCase = (PositionCase)object;
        return this.outlined == positionCase.outlined && this.getPosition().equals(positionCase.getPosition()) && this.scale.equals(positionCase.scale) && this.getLines().equals(positionCase.getLines());
    }

    public int hashCode() {
        return Objects.hash(this.getPosition(), this.outlined, this.scale, this.getLines());
    }
}

