/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.texture.file;

import com.ehhthan.happyhud.api.hud.layer.type.texture.FunctionalTextureLayer;
import com.ehhthan.happyhud.api.resourcepack.texture.PackTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.SizedImage;
import com.ehhthan.happyhud.api.resourcepack.texture.file.AbstractTextureFile;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class SplitTexture
extends AbstractTextureFile {
    private final List<PackTexture> textures = new LinkedList<PackTexture>();

    public SplitTexture(String string, BufferedImage bufferedImage, SizedImage[] sizedImageArray, FunctionalTextureLayer.TextureData textureData) {
        super(string, bufferedImage);
        StringBuilder stringBuilder = new StringBuilder(string.replace(".png", ""));
        stringBuilder.append("/").append(textureData.getOrientation().name().toLowerCase(Locale.ROOT)).append("/");
        if (textureData.isReversed()) {
            stringBuilder.append("reversed").append("/");
        }
        stringBuilder.append(textureData.getIncrement()).append("/");
        String string2 = stringBuilder.toString();
        for (int i = 0; i < sizedImageArray.length; ++i) {
            this.textures.add(new PackTexture(string2 + (i + 1) + ".png", sizedImageArray[i]));
        }
    }

    public List<PackTexture> getTextures() {
        return this.textures;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SplitTexture splitTexture = (SplitTexture)object;
        return this.textures.equals(splitTexture.textures);
    }

    public int hashCode() {
        return Objects.hash(this.textures);
    }
}

