/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.api.resourcepack.builder.BuildablePack;
import com.ehhthan.happyhud.api.resourcepack.builder.ResourceBundle;
import com.ehhthan.happyhud.api.resourcepack.component.SizedComponent;
import com.ehhthan.happyhud.api.resourcepack.component.key.FontKey;
import com.ehhthan.happyhud.api.resourcepack.component.key.TextureKey;
import com.ehhthan.libraries.kyori.adventure.key.Key;
import java.util.Map;

public class ComponentManager {
    private final Map<TextureKey, SizedComponent> components;
    private final Map<FontKey, Key> fonts;

    public ComponentManager(BuildablePack buildablePack) {
        ResourceBundle resourceBundle = buildablePack.build();
        this.components = resourceBundle.getComponents();
        this.fonts = resourceBundle.getFonts();
    }

    public boolean hasComponent(TextureKey textureKey) {
        return this.components.containsKey(textureKey);
    }

    public SizedComponent getComponent(TextureKey textureKey) {
        return this.hasComponent(textureKey) ? this.components.get(textureKey) : SizedComponent.EMPTY;
    }

    public boolean hasFont(FontKey fontKey) {
        return this.fonts.containsKey(fontKey);
    }

    public Key getFont(FontKey fontKey) {
        return this.hasFont(fontKey) ? this.fonts.get(fontKey) : Key.key("default");
    }
}

