/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.resourcepack.asset.font.PackFont;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class FontManager {
    private final Map<String, PackFont> fonts = new HashMap<String, PackFont>();

    public void reload(HappyHUD happyHUD) {
        this.fonts.clear();
        File[] fileArray = new File(happyHUD.getDataFolder(), "assets/font").listFiles((file, string) -> string.endsWith(".yml"));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                for (String string2 : yamlConfiguration.getKeys(false)) {
                    if (!yamlConfiguration.isConfigurationSection(string2)) continue;
                    try {
                        this.fonts.put(string2.toLowerCase(Locale.ROOT), new PackFont(yamlConfiguration.getConfigurationSection(string2)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        happyHUD.getLogger().log(Level.WARNING, String.format("Could not load font '%s': %s", string2, illegalArgumentException.getMessage()));
                    }
                }
            }
        }
    }

    public boolean has(String string) {
        return this.fonts.containsKey(string.toLowerCase(Locale.ROOT));
    }

    public PackFont get(String string) {
        return this.fonts.get(string.toLowerCase(Locale.ROOT));
    }

    public Collection<PackFont> getFonts() {
        return this.fonts.values();
    }
}

