/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.util.ComponentUtil;
import com.ehhthan.happyhud.comp.parser.Parser;
import com.ehhthan.happyhud.comp.parser.PlaceholderAPIParser;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ParserManager {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([^%]+)[%]");
    private final Set<Parser> parsers = new HashSet<Parser>();

    public ParserManager(HappyHUD happyHUD) {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.parsers.add(new PlaceholderAPIParser());
            happyHUD.getLogger().log(Level.INFO, "PlaceholderAPI parser has been registered.");
        }
    }

    public String parse(@NotNull HudHolder hudHolder, @NotNull String string) {
        for (Parser parser : this.parsers) {
            string = parser.parse(hudHolder, string);
        }
        return ComponentUtil.fromLegacy(string);
    }

    public boolean hasPlaceholder(String string) {
        return string != null && PLACEHOLDER_PATTERN.matcher(string).find();
    }
}

