/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.standard;

import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TranslatableComponent;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.Context;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.Tag;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.ehhthan.libraries.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class TranslatableTag {
    private static final String TR = "tr";
    private static final String TRANSLATE = "translate";
    private static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        List list;
        String string = argumentQueue.popOr("A translation key is required").value();
        if (argumentQueue.hasNext()) {
            list = new ArrayList();
            while (argumentQueue.hasNext()) {
                list.add(context.deserialize(argumentQueue.pop().value()));
            }
        } else {
            list = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(string, list));
    }

    @Nullable
    static Emitable claim(Component component) {
        if (!(component instanceof TranslatableComponent) || ((TranslatableComponent)component).fallback() != null) {
            return null;
        }
        TranslatableComponent translatableComponent = (TranslatableComponent)component;
        return tokenEmitter -> {
            tokenEmitter.tag(LANG);
            tokenEmitter.argument(translatableComponent.key());
            for (Component component : translatableComponent.args()) {
                tokenEmitter.argument(component);
            }
        };
    }
}

