/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Zombies.GameArena;
import Zombies.Main;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DoorHandler
implements Listener {
    private Map<Player, Long> doorCoolDown = new HashMap<Player, Long>();

    @EventHandler(priority=EventPriority.LOWEST)
    public void unlockDoor(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = playerInteractEvent.getPlayer();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena == null) {
                return;
            }
            if (gameArena.isAlive(player)) {
                if (this.doorCoolDown.containsKey(player)) {
                    if (System.currentTimeMillis() > this.doorCoolDown.get(player)) {
                        this.doorCoolDown.remove(player);
                    } else {
                        return;
                    }
                }
                this.doorCoolDown.put(player, System.currentTimeMillis() + 300L);
                String string = gameArena.getDoor(player, playerInteractEvent.getClickedBlock().getLocation());
                if (string != null) {
                    playerInteractEvent.setUseItemInHand(Event.Result.DENY);
                    if (gameArena.isDoorUnlockable(player, playerInteractEvent.getClickedBlock().getLocation())) {
                        boolean bl = gameArena.unlockDoor(player, string);
                        if (bl) {
                            if (!player.hasPotionEffect(PotionEffectType.SPEED)) {
                                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 0, true, false));
                            }
                            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("DoorOpen")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.DoorOpen"));
                            gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("OpenDoor").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%doorName%", gameArena.getFakeName(string).replace("_", " ")));
                        } else {
                            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
                            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
                        }
                    } else {
                        player.sendMessage(Main.getInstance().getConfiguration().getMessage("DoorRequiresPowerSwitch"));
                        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("DoorRequiresPowerSwitch")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.DoorRequiresPowerSwitch"));
                    }
                }
            }
        }
    }
}

