/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import HologramAPI.PowerupHologram;
import HologramAPI.WeaponsChestHologram;
import Powerups.PowerupActivateEvent;
import Powerups.PowerupDeactivateEvent;
import Powerups.PowerupType;
import TitleAPI.Title;
import Weapons.Weapon;
import Zombies.GameArena;
import Zombies.Main;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PowerupHandler
implements Listener {
    private Map<GameArena, Map<PowerupType, Map<Location, List<PowerupHologram>>>> powerupHolograms = new HashMap<GameArena, Map<PowerupType, Map<Location, List<PowerupHologram>>>>();
    private Map<GameArena, Map<PowerupType, Long>> powerupDuration = new HashMap<GameArena, Map<PowerupType, Long>>();
    private Map<GameArena, Map<PowerupType, Long>> powerupRemoveDuration = new HashMap<GameArena, Map<PowerupType, Long>>();
    private Title title;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ss.SSS");

    public PowerupHandler() {
        this.title = new Title();
        new BukkitRunnable(){

            /*
             * WARNING - void declaration
             */
            public void run() {
                if (Main.getInstance().getConfiguration().getBoolean("PerksRemoveCooldownEnabled").booleanValue()) {
                    Object object;
                    GameArena gameArena;
                    HashMap<GameArena, void> hashMap = new HashMap<GameArena, void>();
                    for (Map.Entry entry : PowerupHandler.this.powerupRemoveDuration.entrySet()) {
                        gameArena = (GameArena)entry.getKey();
                        object = new ArrayList();
                        for (Object object2 : ((Map)entry.getValue()).entrySet()) {
                            long l = (Long)object2.getValue();
                            if (System.currentTimeMillis() <= l) continue;
                            object.add((PowerupType)((Object)object2.getKey()));
                        }
                        if (!PowerupHandler.this.powerupHolograms.containsKey(gameArena)) continue;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            void object32;
                            Object object2;
                            object2 = (PowerupType)((Object)iterator.next());
                            if (!((Map)PowerupHandler.this.powerupHolograms.get(gameArena)).containsKey(object2)) continue;
                            Map map = (Map)((Map)PowerupHandler.this.powerupHolograms.get(gameArena)).get(object2);
                            for (Map.Entry entry2 : map.entrySet()) {
                                for (PowerupHologram powerupHologram : (List)entry2.getValue()) {
                                    gameArena.removePowerupHologram(powerupHologram);
                                }
                            }
                            Map map2 = (Map)PowerupHandler.this.powerupHolograms.get(gameArena);
                            if (map2.containsKey(object2)) {
                                map2.remove(object2);
                            }
                            PowerupHandler.this.powerupHolograms.put(gameArena, map2);
                            ArrayList arrayList = new ArrayList();
                            if (hashMap.containsKey(gameArena)) {
                                List list = (List)hashMap.get(gameArena);
                            }
                            if (hashMap.containsKey(gameArena)) {
                                object32.add(object2);
                            }
                            hashMap.put(gameArena, object32);
                        }
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        gameArena = (GameArena)entry.getKey();
                        if (!PowerupHandler.this.powerupRemoveDuration.containsKey(gameArena)) continue;
                        object = (Map)PowerupHandler.this.powerupRemoveDuration.get(gameArena);
                        for (Object object2 : (List)entry.getValue()) {
                            if (!object.containsKey(object2)) continue;
                            object.remove(object2);
                        }
                        PowerupHandler.this.powerupRemoveDuration.put(gameArena, object);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
        new BukkitRunnable(){

            public void run() {
                Object object;
                GameArena gameArena;
                HashMap hashMap = new HashMap();
                for (Map.Entry entry : PowerupHandler.this.powerupDuration.entrySet()) {
                    gameArena = (GameArena)entry.getKey();
                    for (Object object2 : ((Map)entry.getValue()).entrySet()) {
                        object = (PowerupType)((Object)object2.getKey());
                        Long l = (Long)object2.getValue();
                        if (System.currentTimeMillis() < l) continue;
                        List<Object> list = new ArrayList<Object>();
                        if (hashMap.containsKey(gameArena)) {
                            list = (List)hashMap.get(gameArena);
                        }
                        list.add(object);
                        hashMap.put(gameArena, list);
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    gameArena = (GameArena)entry.getKey();
                    for (Object object2 : (List)entry.getValue()) {
                        object = new HashMap();
                        if (PowerupHandler.this.powerupDuration.containsKey(gameArena)) {
                            object = (Map)PowerupHandler.this.powerupDuration.get(gameArena);
                        }
                        if (object.containsKey(object2)) {
                            object.remove(object2);
                        }
                        PowerupHandler.this.powerupDuration.put(gameArena, object);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
        new BukkitRunnable(){

            public void run() {
                Object object;
                Map map;
                Object object2;
                Player player;
                HashMap<Player, Object> hashMap = new HashMap<Player, Object>();
                for (Map.Entry entry : PowerupHandler.this.powerupHolograms.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        Object object32;
                        boolean bl = false;
                        player = null;
                        object2 = (PowerupType)((Object)entry2.getKey());
                        map = (HashMap)entry2.getValue();
                        object = (Location)map.keySet().iterator().next();
                        List list = (List)map.values().iterator().next();
                        for (Object object32 : Bukkit.getOnlinePlayers()) {
                            GameArena gameArena;
                            if (bl || (gameArena = Main.getInstance().getConfiguration().getGameArena((Player)object32)) == null || !gameArena.isAlive((Player)object32) || !object32.getWorld().equals(object.getWorld()) || !(object32.getLocation().distanceSquared((Location)object) <= 2.0)) continue;
                            for (PowerupHologram powerupHologram : list) {
                                gameArena.removePowerupHologram(powerupHologram);
                            }
                            bl = true;
                            player = object32;
                        }
                        if (!bl) continue;
                        Object object4 = new HashMap();
                        object32 = Main.getInstance().getConfiguration().getGameArena(player);
                        if (object32 == null) continue;
                        if (hashMap.containsKey(object32)) {
                            object4 = (Map)hashMap.get(object32);
                        }
                        object4.put(object2, player);
                        hashMap.put((Player)object32, object4);
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        PowerupType powerupType = (PowerupType)((Object)entry2.getKey());
                        player = (Player)entry2.getValue();
                        object2 = Main.getInstance().getConfiguration().getGameArena(player);
                        PowerupHandler.this.activate(player, (GameArena)object2, powerupType);
                        map = new HashMap();
                        if (PowerupHandler.this.powerupHolograms.containsKey(object2)) {
                            map = (Map)PowerupHandler.this.powerupHolograms.get(object2);
                        }
                        if (map.containsKey((Object)powerupType)) {
                            map.remove((Object)powerupType);
                        }
                        PowerupHandler.this.powerupHolograms.put(object2, map);
                        if (!Main.getInstance().getConfiguration().getBoolean("PerksRemoveCooldownEnabled").booleanValue()) continue;
                        object = new HashMap();
                        if (PowerupHandler.this.powerupRemoveDuration.containsKey(object2)) {
                            object = (Map)PowerupHandler.this.powerupRemoveDuration.get(object2);
                        }
                        if (object.containsKey((Object)powerupType)) {
                            object.remove((Object)powerupType);
                        }
                        PowerupHandler.this.powerupRemoveDuration.put(object2, object);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 5L, 5L);
    }

    /*
     * WARNING - void declaration
     */
    public void spawnPowerup(Player player, GameArena gameArena, Location location) {
        PowerupType powerupType = this.getPowerupType(gameArena);
        if (powerupType == null) {
            return;
        }
        int n = ThreadLocalRandom.current().nextInt(0, 100);
        if (n >= 90) {
            void var10_12;
            double d = location.getY();
            if (player.getLocation().getY() < d) {
                this.activate(player, gameArena, powerupType);
                return;
            }
            ArrayList<PowerupHologram> arrayList = new ArrayList<PowerupHologram>();
            for (Player object2 : gameArena.getDisplayedPlayers()) {
                PowerupHologram powerupHologram = new PowerupHologram(object2, location.clone().add(0.0, 1.0, 0.0), powerupType);
                gameArena.addPowerupHologram(powerupHologram);
                arrayList.add(powerupHologram);
            }
            HashMap hashMap = new HashMap();
            hashMap.put(location.clone().add(0.0, 1.0, 0.0), arrayList);
            HashMap hashMap2 = new HashMap();
            if (this.powerupHolograms.containsKey(gameArena)) {
                Map<PowerupType, Map<Location, List<PowerupHologram>>> map = this.powerupHolograms.get(gameArena);
            }
            var10_12.put(powerupType, hashMap);
            this.powerupHolograms.put(gameArena, (Map<PowerupType, Map<Location, List<PowerupHologram>>>)var10_12);
            if (Main.getInstance().getConfiguration().getBoolean("PerksRemoveCooldownEnabled").booleanValue()) {
                int n2 = Main.getInstance().getConfiguration().getInteger("PerksRemoveCooldown");
                Map<PowerupType, Long> map = new HashMap<PowerupType, Long>();
                if (this.powerupRemoveDuration.containsKey(gameArena)) {
                    map = this.powerupRemoveDuration.get(gameArena);
                }
                map.put(powerupType, System.currentTimeMillis() + (long)n2);
                this.powerupRemoveDuration.put(gameArena, map);
            }
        }
    }

    private void activate(Player player, GameArena gameArena, PowerupType powerupType) {
        int n = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Powerups." + powerupType.name() + ".Duration");
        long l = System.currentTimeMillis() + (long)(n * 1000);
        Bukkit.getPluginManager().callEvent((Event)new PowerupActivateEvent(player, gameArena, powerupType, n, l));
    }

    public boolean isActive(final GameArena gameArena, final PowerupType powerupType) {
        if (gameArena == null) {
            return false;
        }
        if (this.powerupDuration.containsKey(gameArena) && this.powerupDuration.get(gameArena).containsKey((Object)powerupType)) {
            boolean bl;
            boolean bl2 = bl = System.currentTimeMillis() < this.powerupDuration.get(gameArena).get((Object)powerupType);
            if (!bl) {
                this.powerupDuration.get(gameArena).remove((Object)powerupType);
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.getPluginManager().callEvent((Event)new PowerupDeactivateEvent(gameArena, powerupType));
                    }
                }.runTaskLater((Plugin)Main.getInstance(), 20L);
            }
            return bl;
        }
        return false;
    }

    public boolean hasSpawned(GameArena gameArena, PowerupType powerupType) {
        if (gameArena == null) {
            return false;
        }
        return this.powerupHolograms.containsKey(gameArena) && this.powerupHolograms.get(gameArena).containsKey((Object)powerupType);
    }

    public PowerupType getPowerupType(GameArena gameArena) {
        int n = gameArena.getRound();
        ArrayList<PowerupType> arrayList = new ArrayList<PowerupType>();
        for (PowerupType powerupType : PowerupType.values()) {
            int n2 = Main.getInstance().getConfiguration().getInteger("Powerups." + powerupType.name() + ".MinRound");
            boolean bl = false;
            if (this.hasSpawned(gameArena, powerupType)) {
                bl = true;
            }
            if (this.isActive(gameArena, powerupType)) {
                bl = true;
            }
            if (n < n2 && !bl) {
                bl = true;
            }
            if (bl) continue;
            arrayList.add(powerupType);
        }
        if (!arrayList.isEmpty()) {
            PowerupType powerupType = (PowerupType)((Object)arrayList.get(ThreadLocalRandom.current().nextInt(arrayList.size())));
            return powerupType;
        }
        return null;
    }

    public String getTimeLeft(GameArena gameArena, PowerupType powerupType) {
        if (this.isActive(gameArena, powerupType)) {
            long l = this.powerupDuration.get(gameArena).get((Object)powerupType) - System.currentTimeMillis();
            String string = this.simpleDateFormat.format(l);
            string = string.substring(0, string.length() - 2);
            return string;
        }
        return "0.0";
    }

    @EventHandler
    public void deactivatePowerup(PowerupDeactivateEvent powerupDeactivateEvent) {
        if (powerupDeactivateEvent.getPowerupType() == PowerupType.SHOPPING_SPREE) {
            powerupDeactivateEvent.getGameArena().getWeaponsChestHologram().updateGold();
        }
    }

    @EventHandler
    public void activatePowerup(PowerupActivateEvent powerupActivateEvent) {
        Map<PowerupType, Long> map;
        Player player = powerupActivateEvent.getPlayer();
        int n = powerupActivateEvent.getDuration();
        long l = powerupActivateEvent.getExpireDuration();
        PowerupType powerupType = powerupActivateEvent.getPowerupType();
        GameArena gameArena = powerupActivateEvent.getGameArena();
        if (gameArena == null) {
            return;
        }
        for (Player object : gameArena.getDisplayedPlayers()) {
            object.playSound(object.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("PowerupPickup")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.PowerupPickup"));
        }
        this.title.setTitle(Main.getInstance().getConfiguration().getMessage("Powerups." + powerupType.name() + ".Title"));
        this.title.sendTimes(gameArena.getDisplayedPlayers());
        this.title.sendTitle(gameArena.getDisplayedPlayers());
        gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("Powerups." + powerupType.name() + ".Message").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%duration%", String.valueOf(n)));
        if (n > 0) {
            map = new HashMap();
            if (this.powerupDuration.containsKey(gameArena)) {
                map = this.powerupDuration.get(gameArena);
            }
            map.put(powerupType, l);
            this.powerupDuration.put(gameArena, map);
        }
        if (powerupType == PowerupType.MAX_AMMO) {
            for (Player player2 : gameArena.getPlayers()) {
                for (Map.Entry<Integer, Weapon> entry : Main.getInstance().getWeaponHandler().getWeapons(player2).entrySet()) {
                    Integer n2 = entry.getKey();
                    Weapon weapon = entry.getValue();
                    if (weapon == null) continue;
                    Main.getInstance().getWeaponHandler().loadWeaponAmmo(player2, weapon);
                    if (!gameArena.isAlive(player2) || weapon.getClipAmmo() <= 0) continue;
                    ItemStack itemStack = player2.getInventory().getItem(n2.intValue());
                    itemStack.setDurability((short)0);
                    itemStack.setAmount(weapon.getClipAmmo());
                    player2.getInventory().setItem(n2.intValue(), itemStack);
                }
            }
        }
        if (powerupType == PowerupType.SHOPPING_SPREE) {
            map = gameArena.getWeaponsChestHologram();
            ((WeaponsChestHologram)((Object)map)).updateGold();
        }
        if (powerupType == PowerupType.CARPENTER) {
            gameArena.repairWindows();
        }
        if (powerupType == PowerupType.BONUS_GOLD) {
            int n3 = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Powerups.BONUS_GOLD.GoldValue");
            for (String string : gameArena.getGoldPlayers()) {
                gameArena.addGold(string, n3);
            }
        }
    }
}

