/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.ItemHologram;
import Utils.ItemStackUtils;
import Utils.LocationUtils;
import Zombies.Main;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArmorHologram {
    private Hologram hologram;
    private ItemHologram itemHologram;
    private List<Location> locations;
    private Player player;
    private boolean unlocked;
    private String message;
    private String type;
    private String pack;
    private int typeId;
    private int packId;
    private int gold;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public ArmorHologram(Player player, String string) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        this.gold = fileConfiguration.getInt("ArmorShop.Position." + string + ".Gold");
        this.type = fileConfiguration.getString("ArmorShop.Position." + string + ".Type");
        this.pack = fileConfiguration.getString("ArmorShop.Position." + string + ".Pack");
        String[] stringArray = fileConfiguration.getString("ArmorShop.Position." + string + ".Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("ArmorShop.Position." + string + ".Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("ArmorShop.Position." + string + ".Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.itemHologram = new ItemHologram(location3.clone().add(0.0, 0.73, 0.0));
        this.hologram = new Hologram(location3);
        String string2 = Main.getInstance().getConfiguration().getMessage("Shop.Armor.NotUnlocked").replace("%goldValue%", String.valueOf(this.gold));
        if (this.type.equals("LEATHER")) {
            this.typeId = 1;
            if (this.pack.equals("UP")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.LEATHER.UP");
                this.hologram.setCleanLines(this.message, string2);
                this.helmet = ItemStackUtils.getItem(Material.LEATHER_HELMET, 1, 0, null, new String[0]);
                this.chestplate = ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.chestplate);
                this.packId = 1;
            }
            if (this.pack.equals("DOWN")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.LEATHER.DOWN");
                this.hologram.setCleanLines(this.message, string2);
                this.leggings = ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, null, new String[0]);
                this.boots = ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.leggings);
                this.packId = 2;
            }
        }
        if (this.type.equals("GOLD")) {
            this.typeId = 2;
            if (this.pack.equals("UP")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.GOLD.UP");
                this.hologram.setCleanLines(this.message, string2);
                this.helmet = ItemStackUtils.getItem(this.versionId >= 13 ? Material.GOLDEN_HELMET : Material.getMaterial((String)"GOLD_HELMET"), 1, 0, null, new String[0]);
                this.chestplate = ItemStackUtils.getItem(this.versionId >= 13 ? Material.GOLDEN_CHESTPLATE : Material.getMaterial((String)"GOLD_CHESTPLATE"), 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.chestplate);
                this.packId = 1;
            }
            if (this.pack.equals("DOWN")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.GOLD.DOWN");
                this.hologram.setCleanLines(this.message, string2);
                this.leggings = ItemStackUtils.getItem(this.versionId >= 13 ? Material.GOLDEN_LEGGINGS : Material.getMaterial((String)"GOLD_LEGGINGS"), 1, 0, null, new String[0]);
                this.boots = ItemStackUtils.getItem(this.versionId >= 13 ? Material.GOLDEN_BOOTS : Material.getMaterial((String)"GOLD_BOOTS"), 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.leggings);
                this.packId = 2;
            }
        }
        if (this.type.equals("IRON")) {
            this.typeId = 3;
            if (this.pack.equals("UP")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.IRON.UP");
                this.hologram.setCleanLines(this.message, string2);
                this.helmet = ItemStackUtils.getItem(Material.IRON_HELMET, 1, 0, null, new String[0]);
                this.chestplate = ItemStackUtils.getItem(Material.IRON_CHESTPLATE, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.chestplate);
                this.packId = 1;
            }
            if (this.pack.equals("DOWN")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.IRON.DOWN");
                this.hologram.setCleanLines(this.message, string2);
                this.leggings = ItemStackUtils.getItem(Material.IRON_LEGGINGS, 1, 0, null, new String[0]);
                this.boots = ItemStackUtils.getItem(Material.IRON_BOOTS, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.leggings);
                this.packId = 2;
            }
        }
        if (this.type.equals("DIAMOND")) {
            this.typeId = 4;
            if (this.pack.equals("UP")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.DIAMOND.UP");
                this.hologram.setCleanLines(this.message, string2);
                this.helmet = ItemStackUtils.getItem(Material.DIAMOND_HELMET, 1, 0, null, new String[0]);
                this.chestplate = ItemStackUtils.getItem(Material.DIAMOND_CHESTPLATE, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.chestplate);
                this.packId = 1;
            }
            if (this.pack.equals("DOWN")) {
                this.message = Main.getInstance().getConfiguration().getMessage("Shop.Armor.DIAMOND.DOWN");
                this.hologram.setCleanLines(this.message, string2);
                this.leggings = ItemStackUtils.getItem(Material.DIAMOND_LEGGINGS, 1, 0, null, new String[0]);
                this.boots = ItemStackUtils.getItem(Material.DIAMOND_BOOTS, 1, 0, null, new String[0]);
                this.itemHologram.setCleanItems(this.leggings);
                this.packId = 2;
            }
        }
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getType() {
        return this.type;
    }

    public String getPack() {
        return this.pack;
    }

    public int getGold() {
        return this.gold;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getPackId() {
        return this.packId;
    }

    public boolean isWearing(Player player) {
        boolean bl = false;
        if (this.getHelmet() != null && player.getInventory().getHelmet() != null && this.getHelmet().getType() == player.getInventory().getHelmet().getType()) {
            bl = true;
        }
        if (this.getBoots() != null && player.getInventory().getBoots() != null && this.getBoots().getType() == player.getInventory().getBoots().getType()) {
            bl = true;
        }
        return bl;
    }

    public boolean isDowngrade(ArmorHologram armorHologram) {
        boolean bl = false;
        if (armorHologram.getPackId() == this.getPackId() && this.getTypeId() < armorHologram.getTypeId()) {
            bl = true;
        }
        return bl;
    }

    public void setUnlocked() {
        if (!this.isUnlocked()) {
            String string = Main.getInstance().getConfiguration().getMessage("Shop.Armor.Unlocked");
            this.hologram.destroyFrom(this.player);
            this.hologram.setCleanLines(this.message, string);
            this.hologram.show(this.player);
            this.unlocked = true;
        }
    }

    public boolean purchase(Player player) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (this.isWearing(player)) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Armor.AlreadyWearing"));
            return false;
        }
        if (this.isUnlocked()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Armor.Downgrade"));
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
        this.setUnlocked();
        Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getGold());
        if (this.getHelmet() != null) {
            player.getInventory().setHelmet(this.getHelmet());
        }
        if (this.getChestplate() != null) {
            player.getInventory().setChestplate(this.getChestplate());
        }
        if (this.getLeggings() != null) {
            player.getInventory().setLeggings(this.getLeggings());
        }
        if (this.getBoots() != null) {
            player.getInventory().setBoots(this.getBoots());
        }
        player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Armor.Purchase").replace("%armorName%", ChatColor.stripColor((String)this.message)));
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public ItemHologram getItemHologram() {
        return this.itemHologram;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

