/*
 * Decompiled with CFR 0.152.
 */
package MySQL;

import MySQL.MySQL;
import Zombies.Main;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Stats {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private MySQL sql;
    private boolean mySQLEnabled;
    private boolean localFile;
    private File file = new File(Main.getInstance().getDataFolder(), "storedPlayerStats.yml");
    private FileConfiguration fileConfiguration;

    public Stats() {
        this.mySQLEnabled = Main.getInstance().getConfiguration().getBoolean("MySQL.Enabled");
        this.localFile = Main.getInstance().getConfiguration().getBoolean("MySQL.LocalFile");
        if (this.localFile) {
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
            this.fileConfiguration.options().copyDefaults(true);
        }
    }

    public Stats register() {
        if (!this.mySQLEnabled) {
            return this;
        }
        if (!this.localFile) {
            String string = Main.getInstance().getConfiguration().getMessage("MySQL.Hostname");
            String string2 = Main.getInstance().getConfiguration().getMessage("MySQL.Port");
            String string3 = Main.getInstance().getConfiguration().getMessage("MySQL.Database");
            String string4 = Main.getInstance().getConfiguration().getMessage("MySQL.Username");
            String string5 = Main.getInstance().getConfiguration().getMessage("MySQL.Password");
            this.sql = new MySQL((Plugin)Main.getInstance(), string, string2, string3, string4, string5);
            boolean bl = false;
            try {
                Connection connection = this.sql.openConnection();
                if (connection != null) {
                    bl = connection.isValid(1000);
                }
                MySQL.Update("CREATE TABLE IF NOT EXISTS zombies (id int NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid varchar(50), mapRecordings longtext)");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mySQLEnabled = bl;
        }
        return this;
    }

    public MySQL getSql() {
        return this.sql;
    }

    public boolean isEnabled() {
        return this.mySQLEnabled;
    }

    private void insertField(final String string) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.sql != null && !this.sql.isConnected()) {
            return;
        }
        if (this.localFile) {
            Main.getInstance().getStats().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    Stats.this.fileConfiguration.addDefault(string, (Object)"");
                    try {
                        Stats.this.fileConfiguration.save(Stats.this.file);
                        Stats.this.fileConfiguration.load(Stats.this.file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } else {
            MySQL.Update("INSERT INTO zombies (uuid, mapRecordings) VALUES ('" + string + "', '')");
        }
    }

    public void updateField(final String string, String string2, final Object object) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.sql != null && !this.sql.isConnected()) {
            return;
        }
        if (this.getField(string, string2) == null) {
            this.insertField(string);
        }
        if (this.localFile) {
            Main.getInstance().getStats().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    Stats.this.fileConfiguration.set(string, (Object)String.valueOf(object));
                    try {
                        Stats.this.fileConfiguration.save(Stats.this.file);
                        Stats.this.fileConfiguration.load(Stats.this.file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } else {
            MySQL.Update("UPDATE zombies SET " + string2 + " = '" + object + "' WHERE uuid = '" + string + "'");
        }
    }

    public Object getField(final String string, String string2) {
        if (this.localFile) {
            Future<Object> future = this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    String string2 = null;
                    try {
                        Stats.this.fileConfiguration = (FileConfiguration)YamlConfiguration.loadConfiguration((File)Stats.this.file);
                        Stats.this.fileConfiguration.options().copyDefaults(true);
                        string2 = Stats.this.fileConfiguration.getString(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return string2;
                }
            });
            try {
                return future.get();
            }
            catch (Exception exception) {
            }
        } else {
            String string3 = this.executeStatement("SELECT * FROM zombies WHERE uuid='" + string + "'", string2);
            if (string3 == null) {
                return null;
            }
            return this.executeStatement("SELECT * FROM zombies WHERE uuid='" + string + "'", string2);
        }
        return null;
    }

    public List<String> getAllUniqueEntries() {
        List<String> list = new ArrayList<String>();
        if (this.localFile) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                if (this.file.exists() && this.isEnabled()) {
                    arrayList.addAll(this.fileConfiguration.getKeys(false));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        }
        if (this.isEnabled()) {
            list = this.executeStatement("SELECT * FROM zombies");
        }
        return list;
    }

    private List<String> executeStatement(final String string) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.sql != null && !this.sql.isConnected()) {
            return null;
        }
        Future<List<String>> future = this.executorService.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    if (!Stats.this.sql.hasConnection()) {
                        Stats.this.sql.closeConnection();
                        Stats.this.sql.openConnection();
                    }
                    Connection connection = Stats.this.sql.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("uuid");
                        arrayList.add(string2);
                    }
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return arrayList;
            }
        });
        try {
            return future.get();
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    private String executeStatement(final String string, final String string2) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.sql != null && !this.sql.isConnected()) {
            return null;
        }
        Future<String> future = this.executorService.submit(new Callable<String>(){

            @Override
            public String call() {
                String string3 = null;
                try {
                    if (!Stats.this.sql.hasConnection()) {
                        Stats.this.sql.closeConnection();
                        Stats.this.sql.openConnection();
                    }
                    Connection connection = Stats.this.sql.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.last();
                    if (resultSet.getRow() != 0) {
                        resultSet.first();
                        string3 = resultSet.getString(string2);
                    }
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return string3;
            }
        });
        try {
            return future.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

