/*
 * Decompiled with CFR 0.152.
 */
package Perks;

import Perks.PerkType;
import Utils.ItemStackUtils;
import Zombies.Configuration;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Perk {
    private String displayName;
    private Material material;
    private PerkType perkType;
    private List<String> lores;
    private ItemStack itemStack;

    public Perk setDisplayName(String string) {
        this.displayName = Configuration.translateTextCodes(string);
        return this;
    }

    public Perk setMaterial(Material material) {
        this.material = material;
        return this;
    }

    public Perk setPerkType(PerkType perkType) {
        this.perkType = perkType;
        return this;
    }

    public PerkType getPerkType() {
        return this.perkType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Perk setLores(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Configuration.translateTextCodes(string));
        }
        this.lores = arrayList;
        return this;
    }

    public ItemStack getItemStack() {
        if (this.itemStack != null) {
            return this.itemStack;
        }
        this.itemStack = ItemStackUtils.addItemFlags(ItemStackUtils.getNBTItem(this.material, 1, 0, this.displayName, "{PerkType:\"" + this.perkType.name() + '\"' + "}", this.lores), ItemFlag.HIDE_ATTRIBUTES);
        return this.itemStack;
    }

    public static Perk getPerk(ItemStack itemStack) {
        String string = ItemStackUtils.getNBTString(itemStack, "PerkType");
        if (string != null) {
            String string2 = ItemStackUtils.getNBTString(itemStack, "PerkType");
            Perk perk = new Perk();
            perk.setDisplayName(itemStack.getItemMeta().getDisplayName());
            perk.setMaterial(itemStack.getType());
            perk.setPerkType(PerkType.valueOf(string2));
            return perk;
        }
        return null;
    }
}

