/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class Reflection {
    public static Class<?> getNMSClass(String string) {
        return Reflection.getClass("net.minecraft.server." + Reflection.getVersion() + "." + string);
    }

    public static Class<?> getMinecraftClass(String string) {
        return Reflection.getClass(string);
    }

    public static Class<?> getCraftClass(String string) {
        return Reflection.getClass("org.bukkit.craftbukkit." + Reflection.getVersion() + "." + string);
    }

    public static String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().substring(23);
    }

    public static String getRawVersion() {
        String string = Bukkit.getServer().getClass().getPackage().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static String getNMSVersion() {
        return "net.minecraft.server." + Reflection.getRawVersion() + ".";
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return clazz;
    }

    public static Class<?>[] toParamTypes(Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = Reflection.wrapperToPrimitive(objectArray[i].getClass());
        }
        return classArray;
    }

    public static Enum<?> getEnum(String string) {
        String[] stringArray = string.split("\\.(?=[^\\.]+$)");
        if (stringArray.length == 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            Class<?> clazz = Reflection.getClass(string2);
            return Enum.valueOf(clazz, string3);
        }
        return null;
    }

    public static Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void setValue(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Object getValue(Object object, String string) {
        try {
            Field field = object.getClass().getDeclaredField(string);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object callMethod(Object object, String string, Object ... objectArray) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod(string, Reflection.toParamTypes(objectArray));
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Object object, String string, Class<?> ... classArray) {
        try {
            Method method = object.getClass().getMethod(string, classArray);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Field getField(Field field) {
        field.setAccessible(true);
        return field;
    }
}

