/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Reflection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.util.FileUtil;

public class WorldReset {
    private static int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public static void loadWorldFolder() {
        File file = new File(Bukkit.getWorldContainer() + "/worldsaves");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            String[] stringArray = file.list();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                arrayList.add(string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                WorldCreator worldCreator = new WorldCreator((String)arrayList.get(i));
                worldCreator.createWorld();
            }
        }
    }

    public static void reset(World world) {
        try {
            WorldReset.unloadWorld(world.getName());
            WorldReset.loadWorld(world.getName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static World loadWorld(String string) {
        if (!WorldReset.isLoaded(string)) {
            File file = new File(Bukkit.getWorldContainer() + "/" + string);
            File file2 = new File(Bukkit.getWorldContainer() + "/worldsaves/" + string);
            WorldReset.copyDir(file2, file);
            return Bukkit.getServer().createWorld(new WorldCreator(string));
        }
        return Bukkit.getWorld((String)string);
    }

    private static boolean isLoaded(String string) {
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!world.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean unloadWorld(String string) {
        Object object;
        if (!new File(Bukkit.getWorldContainer() + "/worldsaves").exists()) {
            object = new File(Bukkit.getWorldContainer() + "/worldsaves");
            ((File)object).mkdir();
        }
        if (WorldReset.isLoaded(string)) {
            object = Bukkit.getWorld((String)string);
            if (!new File(Bukkit.getWorldContainer() + "/worldsaves/" + object.getName()).exists()) {
                Bukkit.getConsoleSender().sendMessage("    ");
                Bukkit.getConsoleSender().sendMessage("\u00a77========================================================");
                Bukkit.getConsoleSender().sendMessage("\u00a7eThe World \u00a7a" + object.getName() + " \u00a7ecouldn't reset");
                Bukkit.getConsoleSender().sendMessage("\u00a74Reason: \u00a7cNo World exists in the WorldSaves folder");
                Bukkit.getConsoleSender().sendMessage("\u00a77========================================================");
                Bukkit.getConsoleSender().sendMessage("    ");
            } else {
                File file = new File(Bukkit.getWorldContainer() + "/" + string);
                file.delete();
                for (Player player : object.getPlayers()) {
                    player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
                }
                for (Chunk chunk : object.getLoadedChunks()) {
                    chunk.unload();
                }
                boolean bl = Bukkit.unloadWorld((World)object, (boolean)true);
                return bl;
            }
        }
        return false;
    }

    public static void copyDir(File file, File file2) {
        if (versionId >= 17) {
            FileUtil.copy((File)file, (File)file2);
        } else if (versionId > 13) {
            Class<?> clazz = Reflection.getClass("org.bukkit.craftbukkit.libs.org.apache.commons.io.FileUtils");
            try {
                Method method = clazz.getDeclaredMethod("copyDirectory", File.class, File.class);
                method.invoke(null, file, file2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Class<?> clazz = Reflection.getClass("org.apache.commons.io.FileUtils");
            try {
                Method method = clazz.getDeclaredMethod("copyDirectory", File.class, File.class);
                method.invoke(null, file, file2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

