/*
 * Decompiled with CFR 0.152.
 */
package Weapons;

import Utils.ItemStackUtils;
import Zombies.Configuration;
import Zombies.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Weapon {
    private String weaponName;
    private String displayName;
    private Material material;
    private int customModelData;
    private int bullets;
    private double damage;
    private int ammo;
    private int clipAmmo;
    private double fireRate;
    private double reload;
    private int affectedEnemies;
    private double cooldown;
    private double ultimateDamage;
    private int ultimateAmmo;
    private int ultimateClipAmmo;
    private double ultimateFireRate;
    private double ultimateReload;
    private int ultimateAffectedEnemies;
    private double ultimateCooldown;
    private String hitSound;
    private String shootSound;
    private String particle;
    private List<String> lores;
    private ItemStack itemStack;
    private boolean weaponsChest;
    private boolean ultimate;
    private String ultimateDisplayName;

    public Weapon setBullets(int n) {
        this.bullets = n;
        return this;
    }

    public Weapon setUltimateDisplayName(String string) {
        if (string == null) {
            return this;
        }
        this.ultimateDisplayName = Configuration.translateTextCodes(string);
        return this;
    }

    public Weapon setUltimate(boolean bl) {
        this.ultimate = bl;
        return this;
    }

    public Weapon setWeaponsChest(boolean bl) {
        this.weaponsChest = bl;
        return this;
    }

    public Weapon setWeaponName(String string) {
        this.weaponName = string;
        return this;
    }

    public Weapon setDisplayName(String string) {
        if (string == null) {
            return this;
        }
        this.displayName = Configuration.translateTextCodes(string);
        return this;
    }

    public Weapon setMaterial(Material material) {
        this.material = material;
        return this;
    }

    public Weapon setCustomModelData(int n) {
        this.customModelData = n;
        return this;
    }

    public Weapon setDamage(double d) {
        this.damage = d;
        return this;
    }

    public Weapon setAmmo(int n) {
        this.ammo = n;
        return this;
    }

    public Weapon setClipAmmo(int n) {
        this.clipAmmo = n;
        return this;
    }

    public Weapon setFireRate(double d) {
        this.fireRate = d;
        return this;
    }

    public Weapon setReload(double d) {
        this.reload = d;
        return this;
    }

    public Weapon setAffectedEnemies(int n) {
        this.affectedEnemies = n;
        return this;
    }

    public Weapon setCooldown(double d) {
        this.cooldown = d;
        return this;
    }

    public Weapon setUltimateDamage(double d) {
        this.ultimateDamage = d;
        return this;
    }

    public Weapon setUltimateAmmo(int n) {
        this.ultimateAmmo = n;
        return this;
    }

    public Weapon setUltimateClipAmmo(int n) {
        this.ultimateClipAmmo = n;
        return this;
    }

    public Weapon setUltimateFireRate(double d) {
        this.ultimateFireRate = d;
        return this;
    }

    public Weapon setUltimateReload(double d) {
        this.ultimateReload = d;
        return this;
    }

    public Weapon setUltimateAffectedEnemies(int n) {
        this.ultimateAffectedEnemies = n;
        return this;
    }

    public Weapon setUltimateCooldown(double d) {
        this.ultimateCooldown = d;
        return this;
    }

    public Weapon setHitSound(String string) {
        this.hitSound = string;
        return this;
    }

    public Weapon setShootSound(String string) {
        this.shootSound = string;
        return this;
    }

    public Weapon setParticle(String string) {
        this.particle = string;
        return this;
    }

    public String getWeaponName() {
        return this.weaponName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getBullets() {
        return this.bullets;
    }

    public double getDamage() {
        return this.damage;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public int getClipAmmo() {
        return this.clipAmmo;
    }

    public double getFireRate() {
        return this.fireRate;
    }

    public double getReload() {
        return this.reload;
    }

    public int getAffectedEnemies() {
        return this.affectedEnemies;
    }

    public double getCooldown() {
        return this.cooldown;
    }

    public double getUltimateDamage() {
        return this.ultimateDamage;
    }

    public int getUltimateAmmo() {
        return this.ultimateAmmo;
    }

    public int getUltimateClipAmmo() {
        return this.ultimateClipAmmo;
    }

    public double getUltimateFireRate() {
        return this.ultimateFireRate;
    }

    public double getUltimateReload() {
        return this.ultimateReload;
    }

    public int getUltimateAffectedEnemies() {
        return this.ultimateAffectedEnemies;
    }

    public double getUltimateCooldown() {
        return this.ultimateCooldown;
    }

    public String getHitSound() {
        return this.hitSound;
    }

    public String getShootSound() {
        return this.shootSound;
    }

    public String getParticle() {
        return this.particle;
    }

    public boolean isWeaponsChest() {
        return this.weaponsChest;
    }

    public boolean isUltimate() {
        return this.ultimate;
    }

    public String getUltimateDisplayName() {
        return this.ultimateDisplayName;
    }

    public Weapon updateLores() {
        this.setLores(Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Weapon." + this.weaponName + ".Lores"));
        return this;
    }

    public Weapon setLores(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Configuration.translateTextCodes(string));
        }
        arrayList.add("");
        if (this.ultimate) {
            if (this.ultimateDamage != this.damage) {
                if (this.ultimateDamage > 0.0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.Damage").replace("%oldDamageValue%", String.valueOf(this.damage)).replace("%damageValue%", String.valueOf(this.ultimateDamage))));
                }
            } else if (this.damage > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Damage").replace("%damageValue%", String.valueOf(this.damage))));
            }
            if (this.ultimateAmmo != this.ammo) {
                if (this.ultimateAmmo > 0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.Ammo").replace("%oldAmmoValue%", String.valueOf(this.ammo)).replace("%ammoValue%", String.valueOf(this.ultimateAmmo))));
                }
            } else if (this.ammo > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Ammo").replace("%ammoValue%", String.valueOf(this.ammo))));
            }
            if (this.ultimateClipAmmo != this.clipAmmo) {
                if (this.ultimateClipAmmo > 0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.ClipAmmo").replace("%oldClipAmmoValue%", String.valueOf(this.clipAmmo)).replace("%clipAmmoValue%", String.valueOf(this.ultimateClipAmmo))));
                }
            } else if (this.clipAmmo > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.ClipAmmo").replace("%clipAmmoValue%", String.valueOf(this.clipAmmo))));
            }
            if (this.ultimateFireRate != this.fireRate) {
                if (this.ultimateFireRate > 0.0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.FireRate").replace("%oldFireRateValue%", String.valueOf(this.fireRate)).replace("%fireRateValue%", String.valueOf(this.ultimateFireRate))));
                }
            } else if (this.fireRate > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.FireRate").replace("%fireRateValue%", String.valueOf(this.fireRate))));
            }
            if (this.ultimateReload != this.reload) {
                if (this.ultimateReload > 0.0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.Reload").replace("%oldReloadValue%", String.valueOf(this.reload)).replace("%reloadValue%", String.valueOf(this.ultimateReload))));
                }
            } else if (this.reload > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Reload").replace("%reloadValue%", String.valueOf(this.reload))));
            }
            if (this.ultimateAffectedEnemies != this.affectedEnemies) {
                if (this.ultimateAffectedEnemies > 0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.AffectedEnemies").replace("%oldAffectedEnemiesValue%", String.valueOf(this.affectedEnemies)).replace("%affectedEnemiesValue%", String.valueOf(this.ultimateAffectedEnemies))));
                }
            } else if (this.affectedEnemies > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.AffectedEnemies").replace("%affectedEnemiesValue%", String.valueOf(this.affectedEnemies))));
            }
            if (this.ultimateCooldown != this.cooldown) {
                if (this.ultimateCooldown > 0.0) {
                    arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("UltimateWeaponBuilder.Cooldown").replace("%oldCooldownValue%", String.valueOf(this.cooldown)).replace("%cooldownValue%", String.valueOf(this.ultimateCooldown))));
                }
            } else if (this.cooldown > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Cooldown").replace("%cooldownValue%", String.valueOf(this.cooldown))));
            }
        } else {
            if (this.damage > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Damage").replace("%damageValue%", String.valueOf(this.damage))));
            }
            if (this.ammo > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Ammo").replace("%ammoValue%", String.valueOf(this.ammo))));
            }
            if (this.clipAmmo > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.ClipAmmo").replace("%clipAmmoValue%", String.valueOf(this.clipAmmo))));
            }
            if (this.fireRate > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.FireRate").replace("%fireRateValue%", String.valueOf(this.fireRate))));
            }
            if (this.reload > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Reload").replace("%reloadValue%", String.valueOf(this.reload))));
            }
            if (this.affectedEnemies > 0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.AffectedEnemies").replace("%affectedEnemiesValue%", String.valueOf(this.affectedEnemies))));
            }
            if (this.cooldown > 0.0) {
                arrayList.add(Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Cooldown").replace("%cooldownValue%", String.valueOf(this.cooldown))));
            }
        }
        arrayList.add("");
        for (String string : this.ultimate ? Main.getInstance().getConfig().getStringList("UltimateWeaponBuilder.Lores") : Main.getInstance().getConfig().getStringList("WeaponBuilder.Lores")) {
            arrayList.add(Configuration.translateTextCodes(string));
        }
        this.lores = arrayList;
        return this;
    }

    public ItemStack getItemStack() {
        if (this.itemStack != null) {
            return this.itemStack;
        }
        if (!this.getWeaponName().equals("Knife")) {
            this.itemStack = this.ultimate ? ItemStackUtils.enchant(ItemStackUtils.addItemFlags(ItemStackUtils.getNBTItem(this.material, this.ultimateClipAmmo > 0 ? this.ultimateClipAmmo : 1, 0, this.ultimateDisplayName, "{WeaponDamage:\"" + this.getDamage() + '\"' + ",UltimateWeaponDamage:" + '\"' + this.getUltimateDamage() + '\"' + ",WeaponName:" + '\"' + this.weaponName + '\"' + ",WeaponBullets:" + '\"' + this.getBullets() + '\"' + ",WeaponAmmo:" + '\"' + this.getAmmo() + '\"' + ",UltimateWeaponAmmo:" + '\"' + this.getUltimateAmmo() + '\"' + ",WeaponClipAmmo:" + '\"' + this.getClipAmmo() + '\"' + ",UltimateWeaponClipAmmo:" + '\"' + this.getUltimateClipAmmo() + '\"' + ",WeaponFireRate:" + '\"' + this.getFireRate() + '\"' + ",UltimateWeaponFireRate:" + '\"' + this.getUltimateFireRate() + '\"' + ",WeaponReload:" + '\"' + this.getReload() + '\"' + ",UltimateWeaponReload:" + '\"' + this.getUltimateReload() + '\"' + ",WeaponAffectedEnemies:" + '\"' + this.getAffectedEnemies() + '\"' + ",UltimateWeaponAffectedEnemies:" + '\"' + this.getUltimateAffectedEnemies() + '\"' + ",WeaponCooldown:" + '\"' + this.getCooldown() + '\"' + ",UltimateWeaponCooldown:" + '\"' + this.getUltimateCooldown() + '\"' + ",WeaponHitSound:" + '\"' + this.hitSound + '\"' + ",WeaponShootSound:" + '\"' + this.shootSound + '\"' + ",WeaponParticle:" + '\"' + this.particle + '\"' + ",WeaponsChest:" + '\"' + this.weaponsChest + '\"' + ",Ultimate:" + '\"' + this.ultimate + '\"' + ",UltimateDisplayName:" + '\"' + this.ultimateDisplayName + '\"' + "}", this.lores), ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS), Enchantment.DURABILITY, 1) : ItemStackUtils.addItemFlags(ItemStackUtils.getNBTItem(this.material, this.clipAmmo > 0 ? this.clipAmmo : 1, 0, this.displayName, "{WeaponDamage:\"" + this.getDamage() + '\"' + ",UltimateWeaponDamage:" + '\"' + this.getUltimateDamage() + '\"' + ",WeaponName:" + '\"' + this.weaponName + '\"' + ",WeaponBullets:" + '\"' + this.getBullets() + '\"' + ",WeaponAmmo:" + '\"' + this.getAmmo() + '\"' + ",UltimateWeaponAmmo:" + '\"' + this.getUltimateAmmo() + '\"' + ",WeaponClipAmmo:" + '\"' + this.getClipAmmo() + '\"' + ",UltimateWeaponClipAmmo:" + '\"' + this.getUltimateClipAmmo() + '\"' + ",WeaponFireRate:" + '\"' + this.getFireRate() + '\"' + ",UltimateWeaponFireRate:" + '\"' + this.getUltimateFireRate() + '\"' + ",WeaponReload:" + '\"' + this.getReload() + '\"' + ",UltimateWeaponReload:" + '\"' + this.getUltimateReload() + '\"' + ",WeaponAffectedEnemies:" + '\"' + this.getAffectedEnemies() + '\"' + ",UltimateWeaponAffectedEnemies:" + '\"' + this.getUltimateAffectedEnemies() + '\"' + ",WeaponCooldown:" + '\"' + this.getCooldown() + '\"' + ",UltimateWeaponCooldown:" + '\"' + this.getUltimateCooldown() + '\"' + ",WeaponHitSound:" + '\"' + this.hitSound + '\"' + ",WeaponShootSound:" + '\"' + this.shootSound + '\"' + ",WeaponParticle:" + '\"' + this.particle + '\"' + ",WeaponsChest:" + '\"' + this.weaponsChest + '\"' + ",Ultimate:" + '\"' + this.ultimate + '\"' + ",UltimateDisplayName:" + '\"' + this.ultimateDisplayName + '\"' + "}", this.lores), ItemFlag.HIDE_ATTRIBUTES);
            this.itemStack = ItemStackUtils.applyCustomModelData(this.itemStack, this.customModelData);
        } else {
            this.itemStack = ItemStackUtils.getNBTItem(this.material, 1, 0, this.displayName, "{ItemDamage:\"6.0\"}", this.lores);
            this.itemStack = ItemStackUtils.applyCustomModelData(this.itemStack, this.customModelData);
        }
        return this.itemStack;
    }

    public static Weapon getWeapon(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        String string = ItemStackUtils.getNBTString(itemStack, "WeaponDamage");
        String string2 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponDamage");
        if (string != null && string2 != null) {
            String string3 = ItemStackUtils.getNBTString(itemStack, "WeaponName");
            String string4 = ItemStackUtils.getNBTString(itemStack, "WeaponBullets");
            String string5 = ItemStackUtils.getNBTString(itemStack, "WeaponAmmo");
            String string6 = ItemStackUtils.getNBTString(itemStack, "WeaponClipAmmo");
            String string7 = ItemStackUtils.getNBTString(itemStack, "WeaponFireRate");
            String string8 = ItemStackUtils.getNBTString(itemStack, "WeaponReload");
            String string9 = ItemStackUtils.getNBTString(itemStack, "WeaponAffectedEnemies");
            String string10 = ItemStackUtils.getNBTString(itemStack, "WeaponCooldown");
            String string11 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponAmmo");
            String string12 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponClipAmmo");
            String string13 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponFireRate");
            String string14 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponReload");
            String string15 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponAffectedEnemies");
            String string16 = ItemStackUtils.getNBTString(itemStack, "UltimateWeaponCooldown");
            String string17 = ItemStackUtils.getNBTString(itemStack, "WeaponHitSound");
            String string18 = ItemStackUtils.getNBTString(itemStack, "WeaponShootSound");
            String string19 = ItemStackUtils.getNBTString(itemStack, "WeaponParticle");
            String string20 = ItemStackUtils.getNBTString(itemStack, "WeaponsChest");
            String string21 = ItemStackUtils.getNBTString(itemStack, "Ultimate");
            String string22 = ItemStackUtils.getNBTString(itemStack, "UltimateDisplayName");
            Weapon weapon = new Weapon();
            weapon.setUltimateDisplayName(string22);
            weapon.setUltimate(Boolean.valueOf(string21));
            weapon.setWeaponName(string3);
            weapon.setBullets(Integer.valueOf(string4));
            weapon.setWeaponsChest(Boolean.valueOf(string20));
            weapon.setDisplayName(itemStack.getItemMeta().getDisplayName());
            weapon.setMaterial(itemStack.getType());
            weapon.setDamage(Double.valueOf(string));
            weapon.setAmmo(Integer.valueOf(string5));
            weapon.setClipAmmo(Integer.valueOf(string6));
            weapon.setFireRate(Double.valueOf(string7));
            weapon.setReload(Double.valueOf(string8));
            weapon.setAffectedEnemies(Integer.valueOf(string9));
            weapon.setCooldown(Double.valueOf(string10));
            weapon.setUltimateDamage(Double.valueOf(string2));
            weapon.setUltimateAmmo(Integer.valueOf(string11));
            weapon.setUltimateClipAmmo(Integer.valueOf(string12));
            weapon.setUltimateFireRate(Double.valueOf(string13));
            weapon.setUltimateReload(Double.valueOf(string14));
            weapon.setUltimateAffectedEnemies(Integer.valueOf(string15));
            weapon.setUltimateCooldown(Double.valueOf(string16));
            weapon.setHitSound(string17);
            weapon.setShootSound(string18);
            weapon.setParticle(string19);
            weapon.updateLores();
            return weapon;
        }
        return null;
    }
}

