/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command.sell;

import net.brcdev.shopgui.command.sell.CmdSellSubcommand;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.SellAllResults;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CmdSellAll
extends CmdSellSubcommand {
    public CmdSellAll() {
        this.aliases.add("all");
        this.aliases.add("a");
        this.correctUsage = "/sell all [shop]";
        this.permission = "shopguiplus.sell.all";
        this.senderMustBePlayer = true;
    }

    @Override
    public void execute() {
        if (this.assertPlayerInAllowedGamemode()) {
            return;
        }
        if (this.assertPlayerInAllowedWorld()) {
            return;
        }
        boolean bl = false;
        String string = null;
        Shop shop = null;
        if (this.args.length == 1) {
            bl = true;
            string = this.args[0];
            shop = this.main.getShopManager().getShopById(string);
            if (shop == null) {
                this.msg(Lang.MSG_SELLALL_INVALIDSHOP.toMsg());
                return;
            }
        }
        final Shop shop2 = shop;
        final boolean bl2 = bl;
        final String string2 = string;
        this.main.getPlayerManager().handlePlayerData(this.player, new Callback<PlayerData>(){

            @Override
            public void onSuccess(PlayerData playerData) {
                int n = 0;
                SellAllResults sellAllResults = new SellAllResults();
                ItemStack[] itemStackArray = CmdSellAll.this.player.getInventory().getContents();
                boolean bl = Settings.sellAllExcludeArmorSlots;
                for (int i = 0; i < itemStackArray.length; ++i) {
                    ShopTransactionResult shopTransactionResult;
                    ShopItem shopItem;
                    ItemStack itemStack;
                    if (bl && i >= 36 && i <= 39 || (itemStack = itemStackArray[i]) == null || itemStack.getType() == Material.AIR || (shopItem = bl2 ? shop2.findShopItem(CmdSellAll.this.player, itemStack, Settings.sellAllExcludeFreeItems) : CmdSellAll.this.main.getShopManager().findShopItemByItemStack(CmdSellAll.this.player, playerData, itemStack, Settings.sellAllExcludeFreeItems)) == null || bl2 && !string2.equalsIgnoreCase(shopItem.getShop().getId()) || (shopTransactionResult = CmdSellAll.this.main.getShopManager().handleItemSellAll(CmdSellAll.this.player, shopItem, false)).getResult() != ShopTransactionResult.ShopTransactionResultType.SUCCESS) continue;
                    n += shopTransactionResult.getAmount();
                    sellAllResults.addSellResult(shopItem, shopTransactionResult.getAmount(), shopTransactionResult.getPrice());
                    CmdSellAll.this.player.getInventory().setItem(i, new ItemStack(Material.AIR, 1));
                }
                if (n == 0) {
                    CmdSellAll.this.msg(Lang.MSG_SELLALL_NOITEMS.toMsg());
                } else {
                    CmdSellAll.this.player.updateInventory();
                    if (Settings.sellAllDetailedSummary) {
                        CmdSellAll.this.msg(Lang.MSG_SELLALL_SOLD.toMsg().replace("%quantity%", String.valueOf(n)).replace("%price%", sellAllResults.getTotalEarningsList()));
                    } else {
                        CmdSellAll.this.msg(Lang.MSG_SELLALL_SOLD.toMsg().replace("%quantity%", String.valueOf(n)).replace("%price%", sellAllResults.getTotalEarningsList()));
                    }
                }
            }

            @Override
            public void onFailure(PlayerData playerData) {
                CmdSellAll.this.msg(Lang.MSG_ERROR.toMsg());
            }
        });
    }

    private void doSellAll(PlayerData playerData, boolean bl, Shop shop, String string) {
    }
}

