/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command.shop;

import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.core.BSubCommand;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.modifier.PriceModifierScope;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class CmdShopAddModifier
extends BSubCommand {
    public CmdShopAddModifier() {
        this.aliases.add("addmodifier");
        this.aliases.add("setmodifier");
        this.aliases.add("am");
        this.aliases.add("sm");
        this.correctUsage = "/shop addmodifier <item|shop|global>";
        this.permission = "shopguiplus.shop.addmodifier";
        this.senderMustBePlayer = false;
    }

    @Override
    public void execute() {
        if (this.args.length < 2) {
            this.sendCorrectUsage();
            return;
        }
        final PriceModifierScope priceModifierScope = PriceModifierScope.getScope(this.args[0]);
        if (priceModifierScope == null) {
            this.sendCorrectUsage();
            return;
        }
        final OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)this.args[1]);
        if (offlinePlayer == null) {
            this.msg(Lang.MSG_INVALIDPLAYER.toMsg());
            return;
        }
        if (this.main.getPlayerManager().isPlayerLoaded(offlinePlayer)) {
            try {
                this.handle(priceModifierScope, offlinePlayer, this.main.getPlayerManager().getPlayerData(offlinePlayer));
            }
            catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
                this.msg(Lang.MSG_ERROR.toMsg());
            }
        } else {
            this.main.getDataManager().retrievePlayerData(offlinePlayer.getName(), new Callback<PlayerData>(){

                @Override
                public void onSuccess(PlayerData playerData) {
                    if (playerData != null) {
                        CmdShopAddModifier.this.handle(priceModifierScope, offlinePlayer, playerData);
                    } else {
                        CmdShopAddModifier.this.msg(Lang.MSG_INVALIDPLAYER.toMsg());
                    }
                }

                @Override
                public void onFailure(PlayerData playerData) {
                    CmdShopAddModifier.this.msg(Lang.MSG_ERROR.toMsg());
                }
            });
        }
    }

    private void handle(PriceModifierScope priceModifierScope, OfflinePlayer offlinePlayer, PlayerData playerData) {
        if (priceModifierScope == PriceModifierScope.ITEM) {
            String string;
            if (this.args.length < 5) {
                this.msg(Lang.MSG_USAGE_SUBCOMMAND.toMsg().replace("%usage%", Lang.MSG_CMD_SHOP_ADDMODIFIER_ITEM_USAGE.toString()));
                return;
            }
            String string2 = this.args[2];
            if (this.main.getShopManager().getShopById(string2) == null) {
                this.msg(Lang.MSG_INVALIDSHOP.toMsg().replace("%shop%", string2));
                return;
            }
            Shop shop = this.main.getShopManager().getShopById(string2);
            if (shop.getShopItem(string = this.args[3]) == null) {
                this.msg(Lang.MSG_INVALIDITEM.toMsg().replace("%shop%", string2).replace("%item%", string));
                return;
            }
            ShopItem shopItem = shop.getShopItem(string);
            double d = 1.0;
            if (!NumberUtils.isPositiveDouble(this.args[4])) {
                this.msg(Lang.MSG_MODIFIER_INVALIDAMOUNT.toMsg());
                return;
            }
            d = Double.valueOf(this.args[4]);
            PriceModifierActionType priceModifierActionType = PriceModifierActionType.BOTH;
            if (this.args.length > 5) {
                if (PriceModifierActionType.getType(this.args[5]) != null) {
                    priceModifierActionType = PriceModifierActionType.getType(this.args[5]);
                } else {
                    this.msg(Lang.MSG_MODIFIER_INVALIDTYPE.toMsg());
                    return;
                }
            }
            playerData.getPriceModifiers().setItemModifier(shopItem, priceModifierActionType, d);
            this.main.getDataManager().savePlayerData(playerData);
            if (offlinePlayer.getPlayer() != null) {
                offlinePlayer.getPlayer().sendMessage(Lang.MSG_CMD_SHOP_ADDMODIFIER_ITEM_ADDEDBY.toMsg().replace("%player%", this.getSenderName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%item%", string).replace("%shop%", string2).replace("%modifier%", Settings.formatModifierString(d)));
            }
            this.msg(Lang.MSG_CMD_SHOP_ADDMODIFIER_ITEM_ADDED.toMsg().replace("%player%", offlinePlayer.getName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%item%", string).replace("%shop%", string2).replace("%modifier%", Settings.formatModifierString(d)));
        } else if (priceModifierScope == PriceModifierScope.SHOP) {
            if (this.args.length < 4) {
                this.msg(Lang.MSG_USAGE_SUBCOMMAND.toMsg().replace("%usage%", Lang.MSG_CMD_SHOP_ADDMODIFIER_SHOP_USAGE.toString()));
                return;
            }
            String string = this.args[2];
            if (this.main.getShopManager().getShopById(string) == null) {
                this.msg(Lang.MSG_INVALIDSHOP.toMsg().replace("%shop%", string));
                return;
            }
            Shop shop = this.main.getShopManager().getShopById(string);
            double d = 1.0;
            if (!NumberUtils.isPositiveDouble(this.args[3])) {
                this.msg(Lang.MSG_MODIFIER_INVALIDAMOUNT.toMsg());
                return;
            }
            d = Double.valueOf(this.args[3]);
            PriceModifierActionType priceModifierActionType = PriceModifierActionType.BOTH;
            if (this.args.length > 4) {
                if (PriceModifierActionType.getType(this.args[4]) != null) {
                    priceModifierActionType = PriceModifierActionType.getType(this.args[4]);
                } else {
                    this.msg(Lang.MSG_MODIFIER_INVALIDTYPE.toMsg());
                    return;
                }
            }
            playerData.getPriceModifiers().setShopModifier(shop, priceModifierActionType, d);
            this.main.getDataManager().savePlayerData(playerData);
            if (offlinePlayer.getPlayer() != null) {
                offlinePlayer.getPlayer().sendMessage(Lang.MSG_CMD_SHOP_ADDMODIFIER_SHOP_ADDEDBY.toMsg().replace("%player%", this.getSenderName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%shop%", string).replace("%modifier%", Settings.formatModifierString(d)));
            }
            this.msg(Lang.MSG_CMD_SHOP_ADDMODIFIER_SHOP_ADDED.toMsg().replace("%player%", offlinePlayer.getName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%shop%", string).replace("%modifier%", Settings.formatModifierString(d)));
        } else if (priceModifierScope == PriceModifierScope.GLOBAL) {
            if (this.args.length < 3) {
                this.msg(Lang.MSG_USAGE_SUBCOMMAND.toMsg().replace("%usage%", Lang.MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_USAGE.toString()));
                return;
            }
            double d = 1.0;
            if (!NumberUtils.isPositiveDouble(this.args[2])) {
                this.msg(Lang.MSG_MODIFIER_INVALIDAMOUNT.toMsg());
                return;
            }
            d = Double.valueOf(this.args[2]);
            PriceModifierActionType priceModifierActionType = PriceModifierActionType.BOTH;
            if (this.args.length > 3) {
                if (PriceModifierActionType.getType(this.args[3]) != null) {
                    priceModifierActionType = PriceModifierActionType.getType(this.args[3]);
                } else {
                    this.msg(Lang.MSG_MODIFIER_INVALIDTYPE.toMsg());
                    return;
                }
            }
            playerData.getPriceModifiers().setGlobalModifier(priceModifierActionType, d);
            this.main.getDataManager().savePlayerData(playerData);
            if (offlinePlayer.getPlayer() != null) {
                offlinePlayer.getPlayer().sendMessage(Lang.MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_ADDEDBY.toMsg().replace("%player%", this.getSenderName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%modifier%", Settings.formatModifierString(d)));
            }
            this.msg(Lang.MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_ADDED.toMsg().replace("%player%", offlinePlayer.getName()).replace("%type%", priceModifierActionType.getTranslation()).replace("%modifier%", Settings.formatModifierString(d)));
        }
    }
}

