/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.config;

import net.brcdev.shopgui.core.BConfig;
import net.brcdev.shopgui.util.ChatUtils;

public enum Lang {
    PREFIX("&aShop > &f"),
    LANG_CONSOLE("Console"),
    MSG_AND(" and "),
    MSG_ERROR("Error occurred, please contact the server owner."),
    MSG_INGAMEONLY("This command can be used only in the game."),
    MSG_NOACCESS("You don't have access to do this."),
    MSG_NOTLOADED("Shops haven't been loaded yet, please try again later."),
    MSG_RELOADED("Configuration reloaded!"),
    MSG_USAGE_SUBCOMMAND("Invalid command usage. Correct usage: %usage%"),
    MSG_CMD_SHOP_ADDMODIFIER_ITEM_USAGE("/shop addmodifier item <player> <shop> <item> <value> [buy|sell]"),
    MSG_CMD_SHOP_ADDMODIFIER_ITEM_ADDED("You set &c%player%&f's %type% price modifier for the %item% item in %shop% shop to &c%modifier%&f."),
    MSG_CMD_SHOP_ADDMODIFIER_ITEM_ADDEDBY("Your %type% price modifier for the %item% item in %shop% shop was set to &c%modifier%&f by &c%player%&f."),
    MSG_CMD_SHOP_ADDMODIFIER_SHOP_USAGE("/shop addmodifier shop <player> <shop> <value> [buy|sell]"),
    MSG_CMD_SHOP_ADDMODIFIER_SHOP_ADDED("You set &c%player%&f's %type% price modifier for all items in %shop% shop to &c%modifier%&f."),
    MSG_CMD_SHOP_ADDMODIFIER_SHOP_ADDEDBY("Your %type% price modifier for all items in %shop% shop was set to &c%modifier%&f by &c%player%&f."),
    MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_USAGE("/shop addmodifier global <player> <value> [buy|sell]"),
    MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_ADDED("You set &c%player%&f's %type% price modifier to &c%modifier%&f."),
    MSG_CMD_SHOP_ADDMODIFIER_GLOBAL_ADDEDBY("Your %type% price modifier was set to &c%modifier%&f by &c%player%&f."),
    MSG_CMD_SHOP_CHECK_ITEM("This item's type is &c%material%&f with damage &c%damage%&f."),
    MSG_CMD_SHOP_CHECK_NOITEM("You have to hold an item in your hand in order to check its type."),
    MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_VIEW("&c%player%&f's command modifiers:\nGlobal modifiers:\n%global%\nShop modifiers:\n%shop%\nItem modifiers:\n%item%"),
    MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_VIEWPERMISSIONMODIFIERS("&c%player%&f's permission modifiers:\nGlobal modifiers:\n%global%Shop modifiers:\n%shop%\nItem modifiers:\n%item%"),
    MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_ITEM("Item: &c%item%&f, shop: &c%shop%&f, buy: &c%buy%&f, sell: &c%sell%&f"),
    MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_SHOP("Shop: &c%shop%&f, buy: &c%buy%&f, sell: &c%sell%&f"),
    MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_GLOBAL("Buy: &c%buy%&f, sell: &c%sell%&f"),
    MSG_CMD_SHOP_RESETMODIFIER_ITEM_USAGE("/shop resetmodifier item <player> <shop> <item> [buy|sell]"),
    MSG_CMD_SHOP_RESETMODIFIER_ITEM_RESET("You reset &c%player%&f's %type% price modifier for the %item% item in %shop% shop."),
    MSG_CMD_SHOP_RESETMODIFIER_ITEM_RESETBY("Your %type% price modifier for the %item% item in %shop% shop was reset by &c%player%&f."),
    MSG_CMD_SHOP_RESETMODIFIER_SHOP_USAGE("/shop resetmodifier shop <player> <shop> [buy|sell]"),
    MSG_CMD_SHOP_RESETMODIFIER_SHOP_RESET("You reset &c%player%&f's %type% price modifier for all items in %shop% shop."),
    MSG_CMD_SHOP_RESETMODIFIER_SHOP_RESETBY("Your %type% price modifier for all items in %shop% shop was reset by &c%player%&f."),
    MSG_CMD_SHOP_RESETMODIFIER_GLOBAL_USAGE("/shop resetmodifier global <player> [buy|sell]"),
    MSG_CMD_SHOP_RESETMODIFIER_GLOBAL_RESET("You reset &c%player%&f's %type% price modifier."),
    MSG_CMD_SHOP_RESETMODIFIER_GLOBAL_RESETBY("Your %type% price modifier was reset by &c%player%&f."),
    MSG_MODIFIER_INVALIDAMOUNT("Invalid modifier value specified. Valid values are for instance 0.50 which is 50%, 2.0 which is 200% etc."),
    MSG_MODIFIER_INVALIDTYPE("Invalid modifier type specified. Valid values are buy, sell and both."),
    MSG_MODIFIER_BUY("buy"),
    MSG_MODIFIER_SELL("sell"),
    MSG_MODIFIER_BOTH("buy & sell"),
    MSG_INVALIDPLAYER("Invalid player name specified."),
    MSG_INVALIDSHOP("Shop with ID &c%shop%&f not found."),
    MSG_INVALIDITEM("Item with ID &c%item%&f not found in &c%shop%&f."),
    MSG_NOACCESSTOSHOP("You don't have access to &c%shop%&f shop."),
    MSG_NODIRECTACCESSTOSHOP("You can't access the &c%shop%&f shop."),
    MSG_MAINMENUDISABLED("You can't use this command. Please use /shop <id> instead."),
    MSG_WORLDBLACKLISTED("You can't access %shop% in this world."),
    MSG_WORLDBANNED("You can't access the shop in this world."),
    MSG_WORLDBANNEDTARGET("%player% can't access the shop in that world."),
    MSG_GAMEMODEBANNED("You can't access the shop when in gamemode %gamemode%."),
    MSG_GAMEMODEBANNEDTARGET("%player% can't access the shop when in gamemode %gamemode%."),
    MSG_ITEM_FULLINVENTORY("You don't have enough free space in your inventory."),
    MSG_ITEM_CANNOTAFFORD("You need &c%price%&f to buy &c%amount% x %item%&f."),
    MSG_ITEM_CANNOTBUY("You can't buy this item."),
    MSG_ITEM_CANNOTSELL("You can't sell this item."),
    MSG_ITEM_BOUGHT("You bought &c%amount% x %item%&f for &c%price%&f."),
    MSG_ITEM_BOUGHTFREE("You received &c%amount% x %item%&f."),
    MSG_ITEM_NOTENOUGH("You don't have &c%amount% x %item%&f to sell."),
    MSG_ITEM_SOLD("You sold &a%amount% x %item%&f for &a%price%&f."),
    MSG_ITEM_SOLDFREE("You gave away &a%amount% x %item%&f."),
    MSG_ITEM_SOLDALL("You sold all &a%item%&f (&a%amount% x %item%&f) for &a%price%&f."),
    MSG_ITEM_SOLDALLFREE("You gave away all &a%item%&f (&a%amount% x %item%&f)."),
    MSG_ITEM_NOACCESS("You don't have access to this item."),
    MSG_ENCHANT_CANNOTAPPLY("Enchantment &c%enchantment%&f cannot be applied to the item you're holding."),
    MSG_ENCHANT_ALREADYAPPLIED("This item already has &c%enchantment%&f applied."),
    MSG_ENCHANT_LEVELDIFF("You need an item with at least &c%enchantment% %level%&f applied."),
    MSG_ENCHANT_CANNOTAFFORD("You need &c%price%&f to buy &c%enchantment%&f."),
    MSG_ENCHANT_MAX("This item already has the maximum amount of enchantments (%amount%)."),
    MSG_ENCHANT_TOOMANY("You can't enchant more than %amount% items at once."),
    MSG_ENCHANT_BOUGHT("You bought &c%enchantment%&f enchantment for &c%price%&f."),
    MSG_ENCHANT_BOUGHTFREE("You received &c%enchantment%&f."),
    MSG_PERMISSION_PERMISSIONSDISABLED("Permissions are disabled, please contact server's owner."),
    MSG_PERMISSION_ALREADYHAVE("You already have the &c%permission%&f permission."),
    MSG_PERMISSION_CANNOTAFFORD("You need &c%price%&f to buy &c%permission%&f."),
    MSG_PERMISSION_BOUGHT("You bought &c%permission%&f permission for &c%price%&f."),
    MSG_PERMISSION_BOUGHTFREE("You received &c%permission%&f."),
    MSG_COMMAND_BOUGHT("You bought &c%command%&f for &c%price%&f."),
    MSG_COMMAND_BOUGHTFREE("You received &c%command%&f."),
    MSG_COMMAND_CANNOTAFFORD("You need &c%price%&f to buy &c%command%&f command."),
    MSG_SELLHAND_NOITEM("You have to hold an item in your hand in order to sell it."),
    MSG_SELLHAND_INVALIDQUANTITY("Invalid quantity specified. Must be between 1 and %max%."),
    MSG_SELLHAND_CANNOTSELL("You can't sell this item."),
    MSG_SELLHAND_MULTIPLEQUANTITYONLY("You can't sell that quantity. Only multiples of %quantity% are allowed for this item."),
    MSG_SELLHANDALL_SOLD("You sold &a%quantity% x %item%&f for a total of &a%price%&f."),
    MSG_SELLALL_NOITEMS("You don't have any items you can sell."),
    MSG_SELLALL_SOLD("You sold &a%quantity% items&f for a total of &a%price%&f."),
    MSG_SELLALL_INVALIDSHOP("Invalid shop specified."),
    DIALOG_AMOUNTSELECTION_BUY_NAME("&2Buying %item%"),
    DIALOG_AMOUNTSELECTION_SELL_NAME("&cSelling %item%"),
    DIALOG_AMOUNTSELECTION_BULKBUY_NAME("&cBuying stacks of %item%"),
    DIALOG_AMOUNTSELECTION_BULKSELL_NAME("&cSelling stacks of %item%"),
    SHOP_PERMISSION_ALREADYOWNED("&4(Already owned)"),
    SHOP_PERMISSION_NOTOWNED("&a(Not owned)"),
    MSG_NUMBERFORMAT_SHORTSCALE_THOUSAND(" Thousand"),
    MSG_NUMBERFORMAT_SHORTSCALE_MILLION(" Million"),
    MSG_NUMBERFORMAT_SHORTSCALE_BILLION(" Billion"),
    MSG_NUMBERFORMAT_SHORTSCALE_TRILLION(" Trillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_QUADRILLION(" Quadrillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_QUINTILLION(" Quintillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_SEXTILLION(" Sextillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_SEPTILLION(" Septillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_OCTILLION(" Octillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_NONILLION(" Nonillion"),
    MSG_NUMBERFORMAT_SHORTSCALE_DECILLION(" Decillion");

    private static BConfig config;
    private String defaultValue;

    private Lang(String string2) {
        this.defaultValue = string2;
    }

    public static void setConfig(BConfig bConfig) {
        config = bConfig;
        Lang.load();
    }

    private static void load() {
        for (Lang lang : Lang.values()) {
            if (config.getConfig().getString(lang.getPath()) != null) continue;
            config.getConfig().set(lang.getPath(), (Object)lang.getDefaultValue());
        }
        config.save();
    }

    public String getPath() {
        return this.name().replace("_", ".");
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.fixColors(config.getConfig().getString(this.getPath()));
    }

    public String toMsg() {
        boolean bl = true;
        if (bl) {
            return this.fixColors(config.getConfig().getString(PREFIX.getPath()) + config.getConfig().getString(this.getPath()));
        }
        return this.fixColors(config.getConfig().getString(this.getPath()));
    }

    private String fixColors(String string) {
        return ChatUtils.fixColors(string);
    }
}

