/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.economy;

import java.util.LinkedHashMap;
import java.util.Map;
import me.realized.tokenmanager.api.TokenManager;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.exception.economy.EconomyProviderLoadException;
import net.brcdev.shopgui.provider.economy.EconomyCoinsEngineProvider;
import net.brcdev.shopgui.provider.economy.EconomyExpLevelProvider;
import net.brcdev.shopgui.provider.economy.EconomyExpProvider;
import net.brcdev.shopgui.provider.economy.EconomyGemsEconomyProvider;
import net.brcdev.shopgui.provider.economy.EconomyGringottsProvider;
import net.brcdev.shopgui.provider.economy.EconomyMySqlTokensProvider;
import net.brcdev.shopgui.provider.economy.EconomyPlayerPointsProvider;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.provider.economy.EconomyTokenEnchantProvider;
import net.brcdev.shopgui.provider.economy.EconomyTokenManagerProvider;
import net.brcdev.shopgui.provider.economy.EconomyVaultProvider;
import net.brcdev.shopgui.provider.economy.EconomyVotingPluginProvider;
import net.brcdev.shopgui.util.Constants;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.gestern.gringotts.Gringotts;

public class EconomyManager {
    private ShopGuiPlugin main;
    private Map<EconomyType, EconomyProvider> registeredEconomyProviders;
    private Map<EconomyType, EconomyProvider> enabledEconomyProviders;

    public EconomyManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.registeredEconomyProviders = new LinkedHashMap<EconomyType, EconomyProvider>();
        this.enabledEconomyProviders = new LinkedHashMap<EconomyType, EconomyProvider>();
    }

    public void registerCustomEconomyProvider(EconomyProvider economyProvider) {
        EconomyType economyType = EconomyType.CUSTOM;
        this.setPrefixSuffixFromSettings(economyType, economyProvider);
        this.registeredEconomyProviders.put(economyType, economyProvider);
        this.main.info("Registered custom economy provider '" + economyProvider.getName() + "'.");
    }

    public EconomyProvider getEconomyProvider(EconomyType economyType) {
        return this.enabledEconomyProviders.containsKey((Object)economyType) ? this.enabledEconomyProviders.get((Object)economyType) : this.getDefaultEconomyProvider();
    }

    public EconomyProvider getDefaultEconomyProvider() {
        return this.enabledEconomyProviders.values().iterator().next();
    }

    public boolean setup() {
        this.registerDefaultProviders();
        return this.loadEnabledProviders();
    }

    public void registerDefaultProviders() {
        for (EconomyType economyType : Settings.economyTypes) {
            EconomyProvider economyProvider;
            if (this.registeredEconomyProviders.containsKey((Object)economyType) || economyType == EconomyType.CUSTOM) continue;
            try {
                economyProvider = this.loadEconomyProvider(economyType);
            }
            catch (EconomyProviderLoadException economyProviderLoadException) {
                continue;
            }
            this.registeredEconomyProviders.put(economyType, economyProvider);
        }
    }

    public boolean loadEnabledProviders() {
        this.enabledEconomyProviders.clear();
        for (EconomyType economyType : Settings.economyTypes) {
            if (!this.registeredEconomyProviders.containsKey((Object)economyType)) continue;
            EconomyProvider economyProvider = this.registeredEconomyProviders.get((Object)economyType);
            this.setPrefixSuffixFromSettings(economyType, economyProvider);
            this.enabledEconomyProviders.put(economyType, economyProvider);
            this.main.info(economyProvider.getName() + " economy enabled.");
        }
        if (this.enabledEconomyProviders.isEmpty()) {
            this.main.warning("No supported economy plugins found, disabling the plugin.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.main);
        } else {
            this.main.info("Using " + this.getDefaultEconomyProvider().getName() + " as default economy provider.");
        }
        return !this.enabledEconomyProviders.isEmpty();
    }

    private EconomyProvider loadEconomyProvider(EconomyType economyType) {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        EconomyProvider economyProvider = null;
        switch (economyType) {
            case EXP: {
                economyProvider = new EconomyExpProvider();
                break;
            }
            case EXP_LEVELS: {
                economyProvider = new EconomyExpLevelProvider();
                break;
            }
            case COINS_ENGINE: {
                if (!this.isPluginEnabled(Constants.PLUGIN_COINSENGINE)) break;
                economyProvider = new EconomyCoinsEngineProvider();
                break;
            }
            case GEMS_ECONOMY: {
                if (!this.isPluginEnabled(Constants.PLUGIN_GEMSECONOMY)) break;
                economyProvider = new EconomyGemsEconomyProvider();
                break;
            }
            case GRINGOTTS: {
                if (!this.isPluginEnabled(Constants.PLUGIN_GRINGOTTS)) break;
                Gringotts gringotts = (Gringotts)pluginManager.getPlugin(Constants.PLUGIN_GRINGOTTS);
                economyProvider = new EconomyGringottsProvider(gringotts.getEco());
                break;
            }
            case MYSQL_TOKENS: {
                if (!this.isPluginEnabled(Constants.PLUGIN_MYSQLTOKENS)) break;
                economyProvider = new EconomyMySqlTokensProvider();
                break;
            }
            case PLAYER_POINTS: {
                if (!this.isPluginEnabled(Constants.PLUGIN_PLAYERPOINTS)) break;
                PlayerPoints playerPoints = (PlayerPoints)pluginManager.getPlugin(Constants.PLUGIN_PLAYERPOINTS);
                economyProvider = new EconomyPlayerPointsProvider(playerPoints.getAPI());
                break;
            }
            case TOKEN_ENCHANT: {
                if (!this.isPluginEnabled(Constants.PLUGIN_TOKENENCHANT)) break;
                economyProvider = new EconomyTokenEnchantProvider();
                break;
            }
            case TOKEN_MANAGER: {
                if (!this.isPluginEnabled(Constants.PLUGIN_TOKENMANAGER)) break;
                TokenManager tokenManager = (TokenManager)Bukkit.getPluginManager().getPlugin("TokenManager");
                economyProvider = new EconomyTokenManagerProvider(tokenManager);
                break;
            }
            case VAULT: {
                RegisteredServiceProvider registeredServiceProvider;
                if (!this.isPluginEnabled(Constants.PLUGIN_VAULT) || (registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class)) == null) break;
                economyProvider = new EconomyVaultProvider((Economy)registeredServiceProvider.getProvider());
                break;
            }
            case VOTING_PLUGIN: {
                if (!this.isPluginEnabled(Constants.PLUGIN_VOTINGPLUGIN)) break;
                economyProvider = new EconomyVotingPluginProvider();
            }
        }
        if (economyProvider == null) {
            this.main.warning("Failed to register " + economyType.name() + " economy.");
            throw new EconomyProviderLoadException();
        }
        this.main.info(economyProvider.getName() + " economy registered.");
        this.setPrefixSuffixFromSettings(economyType, economyProvider);
        return economyProvider;
    }

    private boolean isPluginEnabled(String string) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(string);
        return plugin != null && plugin.isEnabled();
    }

    private void setPrefixSuffixFromSettings(EconomyType economyType, EconomyProvider economyProvider) {
        String string;
        String string2 = Settings.getCurrencyPrefix(economyType);
        if (string2 != null) {
            economyProvider.setCurrencyPrefix(string2);
        }
        if ((string = Settings.getCurrencySuffix(economyType)) != null) {
            economyProvider.setCurrencySuffix(string);
        }
    }
}

