/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.gui.gui;

import java.util.ArrayList;
import java.util.List;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.gui.gui.OpenGui;
import net.brcdev.shopgui.inventory.AmountSelectionGuiInventoryHolder;
import net.brcdev.shopgui.permission.PermissionManager;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.settings.MenuWithItemSettings;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.shop.item.ShopItemType;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.InventoryUtils;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AmountSelectionGui
extends OpenGui {
    private ShopManager.ShopAction actionType;
    private ShopItem shopItem;
    private ItemStack itemStack;
    private List<String> originalLore;

    public AmountSelectionGui(Player player, PlayerData playerData, OpenGui.MenuType menuType, Shop shop, ShopManager.ShopAction shopAction, ShopItem shopItem, ItemStack itemStack) {
        super(player, playerData, menuType, shop);
        this.actionType = shopAction;
        this.shopItem = shopItem;
        this.itemStack = itemStack;
        this.loadLore();
        this.createInventory();
    }

    public ShopManager.ShopAction getActionType() {
        return this.actionType;
    }

    public void setActionType(ShopManager.ShopAction shopAction) {
        this.actionType = shopAction;
    }

    public ShopItem getShopItem() {
        return this.shopItem;
    }

    public void setShopItem(ShopItem shopItem) {
        this.shopItem = shopItem;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public List<String> getOriginalLore() {
        return this.originalLore;
    }

    public void setOriginalLore(List<String> list) {
        this.originalLore = list;
    }

    private void createInventory() {
        MenuWithItemSettings menuWithItemSettings = Settings.amountSelectionGUISettings;
        String string = "";
        if (this.actionType == ShopManager.ShopAction.BUY) {
            string = Lang.DIALOG_AMOUNTSELECTION_BUY_NAME.toString().replace("%item%", ItemUtils.formatItemName(this.itemStack, this.player));
        } else if (this.actionType == ShopManager.ShopAction.SELL) {
            string = Lang.DIALOG_AMOUNTSELECTION_SELL_NAME.toString().replace("%item%", ItemUtils.formatItemName(this.itemStack, this.player));
        }
        if (!NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && string.length() > 26) {
            string = string.substring(0, 26);
        }
        Inventory inventory = new AmountSelectionGuiInventoryHolder(menuWithItemSettings.getRows() * 9, string).getInventory();
        menuWithItemSettings.getButton("confirm").setInInventory(inventory);
        menuWithItemSettings.getButton("cancel").setInInventory(inventory);
        if (this.shopItem.getType() == ShopItemType.ITEM) {
            if (this.actionType == ShopManager.ShopAction.BUY) {
                if (PermissionManager.hasPermission(this.player, "shopguiplus.buymore")) {
                    menuWithItemSettings.getButton("buyMore").setInInventory(inventory);
                }
            } else if (this.actionType == ShopManager.ShopAction.SELL) {
                if (PermissionManager.hasPermission(this.player, "shopguiplus.sellmore")) {
                    menuWithItemSettings.getButton("sellMore").setInInventory(inventory);
                }
                if (Settings.enableSellGUISellAll && this.shop.isEnableSellGUISellAll()) {
                    menuWithItemSettings.getButton("sellAll").setInInventory(inventory);
                }
            }
        }
        inventory.setItem(menuWithItemSettings.getItemSlot(), this.itemStack);
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
            inventory.setItem(i, menuWithItemSettings.getFillItem().clone());
        }
        this.setInventory(inventory);
        this.handleAmountChange(this.getItemAmount());
    }

    public void setItemAmount(PlayerData playerData, int n) {
        playerData.setLastGuiClick(System.currentTimeMillis());
        this.itemStack.setAmount(n);
        this.inventory.getItem(Settings.amountSelectionGUISettings.getItemSlot()).setAmount(n);
        this.handleAmountChange(n);
    }

    private void loadLore() {
        this.originalLore = this.itemStack.hasItemMeta() && this.itemStack.getItemMeta().hasLore() ? this.itemStack.getItemMeta().getLore() : new ArrayList<String>();
    }

    public int getItemAmount() {
        return this.itemStack.getAmount();
    }

    private void handleAmountChange(int n) {
        int n2 = this.getMaxStackSize();
        if (n > 1 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("set1").setInInventory(this.inventory);
        } else if (n == 1 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("set1").setBlankInInventory(this.inventory);
        }
        if (n > 1 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("remove1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("remove1").setInInventory(this.inventory);
        } else if (n <= 1 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("remove1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("remove1").setBlankInInventory(this.inventory);
        }
        if (n > 10 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("remove10").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("remove10").setInInventory(this.inventory);
        } else if (n <= 10 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("remove10").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("remove10").setBlankInInventory(this.inventory);
        }
        if (n < n2 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("add1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("add1").setInInventory(this.inventory);
        } else if (n >= n2 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("add1").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("add1").setBlankInInventory(this.inventory);
        }
        if (n <= n2 - 10 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("add10").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("add10").setInInventory(this.inventory);
        } else if (n > n2 - 10 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("add10").getSlot())) {
            Settings.amountSelectionGUISettings.getButton("add10").setBlankInInventory(this.inventory);
        }
        if (n2 == 16) {
            if (n < 16 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set16").getSlot())) {
                Settings.amountSelectionGUISettings.getButton("set16").setInInventory(this.inventory);
            } else if (n == 16 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set16").getSlot())) {
                Settings.amountSelectionGUISettings.getButton("set16").setBlankInInventory(this.inventory);
            }
        } else if (n2 == 64) {
            if (n < 64 && this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set64").getSlot())) {
                Settings.amountSelectionGUISettings.getButton("set64").setInInventory(this.inventory);
            } else if (n == 64 && !this.isSlotEmpty(Settings.amountSelectionGUISettings.getButton("set64").getSlot())) {
                Settings.amountSelectionGUISettings.getButton("set64").setBlankInInventory(this.inventory);
            }
        }
        if (this.actionType == ShopManager.ShopAction.BUY) {
            ItemMeta itemMeta = this.inventory.getItem(Settings.amountSelectionGUISettings.getItemSlot()).getItemMeta();
            ArrayList<String> arrayList = new ArrayList<String>(this.originalLore);
            arrayList.addAll(Settings.shopItemLoreFormatItemBuyGUI);
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, ChatUtils.fixColors(((String)arrayList.get(i)).replace("%buy%", ChatUtils.formatCurrencyString(this.shop, this.shopItem.getBuyPriceForAmount(this.player, n)))));
            }
            itemMeta.setLore(arrayList);
            this.inventory.getItem(Settings.amountSelectionGUISettings.getItemSlot()).setItemMeta(itemMeta);
        } else if (this.actionType == ShopManager.ShopAction.SELL) {
            int n3;
            ItemMeta itemMeta = this.inventory.getItem(Settings.amountSelectionGUISettings.getItemSlot()).getItemMeta();
            ArrayList<String> arrayList = new ArrayList<String>(this.originalLore);
            arrayList.addAll(Settings.shopItemLoreFormatItemSellGUI);
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList.set(n3, ChatUtils.fixColors(((String)arrayList.get(n3)).replace("%sell%", ChatUtils.formatCurrencyString(this.shop, this.shopItem.getSellPriceForAmount(this.player, n)))));
            }
            itemMeta.setLore(arrayList);
            this.inventory.getItem(Settings.amountSelectionGUISettings.getItemSlot()).setItemMeta(itemMeta);
            if (Settings.enableSellGUISellAll && this.shop.isEnableSellGUISellAll() && Settings.amountSelectionGUISettings.getButton("sellAll").getSlot() > 0) {
                n3 = 0;
                double d = 0.0;
                if (Settings.allowAllSellAllStackSizes) {
                    d = this.shopItem.getSellPrice(this.player) / (double)this.shopItem.getOriginalStackSize() * (double)InventoryUtils.getPlayersItemAmount(this.player, this.getItemStack(), this.shopItem.isCompareMeta(), this.shopItem.isCompareModel(), this.shopItem.isCompareDamage(), this.shopItem.isCompareNbt(), Settings.sellAllExcludeArmorSlots);
                } else {
                    n3 = InventoryUtils.getPlayersItemAmount(this.player, this.getItemStack(), this.shopItem.isCompareMeta(), this.shopItem.isCompareModel(), this.shopItem.isCompareDamage(), this.shopItem.isCompareNbt(), Settings.sellAllExcludeArmorSlots) / this.getItemStack().getAmount();
                    d = this.shopItem.getSellPrice(this.player) * (double)this.getItemStack().getAmount() / (double)this.shopItem.getOriginalStackSize() * (double)n3;
                }
                ItemMeta itemMeta2 = this.inventory.getItem(Settings.amountSelectionGUISettings.getButton("sellAll").getSlot()).getItemMeta();
                ArrayList<String> arrayList2 = new ArrayList<String>(Settings.shopItemLoreFormatItemSellGUISellAll);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (Settings.allowAllSellAllStackSizes || n3 > 0) {
                        arrayList2.set(i, ChatUtils.fixColors(((String)arrayList2.get(i)).replace("%sell%", ChatUtils.formatCurrencyString(this.shop, d))));
                        continue;
                    }
                    arrayList2.set(i, ChatUtils.fixColors(((String)arrayList2.get(i)).replace("%sell%", "-")));
                }
                itemMeta2.setLore(arrayList2);
                this.inventory.getItem(Settings.amountSelectionGUISettings.getButton("sellAll").getSlot()).setItemMeta(itemMeta2);
            }
        }
    }

    private boolean isSlotEmpty(int n) {
        return n >= 0 && (this.inventory.getItem(n) == null || this.inventory.getItem(n).getType() == Material.AIR || ItemUtils.compareItemStacks(this.inventory.getItem(n), Settings.amountSelectionGUISettings.getFillItem(), true, true, true, true));
    }

    @Deprecated
    public int getMaxStackSize() {
        return this.shopItem.getMaxStackSize();
    }
}

