/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.provider.item.BreweryItemProvider;
import net.brcdev.shopgui.provider.item.CrackShotItemProvider;
import net.brcdev.shopgui.provider.item.CustomItemsItemProvider;
import net.brcdev.shopgui.provider.item.ExecutableItemsItemProvider;
import net.brcdev.shopgui.provider.item.HeadDatabaseItemProvider;
import net.brcdev.shopgui.provider.item.ItemProvider;
import net.brcdev.shopgui.provider.item.ItemsAdderItemProvider;
import net.brcdev.shopgui.provider.item.MMOItemsItemProvider;
import net.brcdev.shopgui.provider.item.OraxenItemProvider;
import net.brcdev.shopgui.provider.item.SlimefunItemProvider;
import net.brcdev.shopgui.util.Constants;
import net.brcdev.shopgui.util.PluginUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ItemManager {
    private ShopGuiPlugin main;
    private List<ItemProvider> itemProviders;

    public ItemManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.itemProviders = new ArrayList<ItemProvider>();
    }

    public void registerDefaultItemProviders() {
        ItemProvider itemProvider;
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_HEADDATABASE)) {
            itemProvider = new HeadDatabaseItemProvider();
            this.registerItemProvider(itemProvider, false);
            pluginManager.registerEvents((Listener)itemProvider, (Plugin)this.main);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_MMOITEMS)) {
            itemProvider = new MMOItemsItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_CRACKSHOT)) {
            itemProvider = new CrackShotItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_ORAXEN)) {
            itemProvider = new OraxenItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_CUSTOMITEMS)) {
            itemProvider = new CustomItemsItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_BREWERY)) {
            itemProvider = new BreweryItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_EXECUTABLEITEMS) && PluginUtils.isPluginInstalled(Constants.PLUGIN_SCORE)) {
            itemProvider = new ExecutableItemsItemProvider();
            this.registerItemProvider(itemProvider, false);
            if (!itemProvider.isReady()) {
                pluginManager.registerEvents((Listener)itemProvider, (Plugin)this.main);
            }
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_ITEMSADDER)) {
            itemProvider = new ItemsAdderItemProvider();
            this.registerItemProvider(itemProvider, false);
            pluginManager.registerEvents((Listener)itemProvider, (Plugin)this.main);
        }
        if (PluginUtils.isPluginInstalled(Constants.PLUGIN_SLIMEFUN)) {
            itemProvider = new SlimefunItemProvider();
            this.registerItemProvider(itemProvider, false);
        }
    }

    public void registerItemProvider(ItemProvider itemProvider) {
        this.registerItemProvider(itemProvider, true);
    }

    public void registerItemProvider(ItemProvider itemProvider, boolean bl) {
        this.itemProviders.add(itemProvider);
        if (bl) {
            this.main.info("Registered item provider '" + itemProvider.getName() + "'.");
        }
    }

    public boolean areAllProvidersReady() {
        Iterator<ItemProvider> iterator = this.itemProviders.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            this.main.warning("Removing NULL item provider!");
            iterator.remove();
        }
        return this.itemProviders.stream().allMatch(ItemProvider::isReady);
    }

    public ItemStack loadItem(ConfigurationSection configurationSection) {
        ItemProvider itemProvider;
        ItemStack itemStack = null;
        Iterator<ItemProvider> iterator = this.itemProviders.iterator();
        while (iterator.hasNext() && (itemStack = (itemProvider = iterator.next()).loadItem(configurationSection)) == null) {
        }
        return itemStack;
    }

    public boolean compare(ItemStack itemStack, ItemStack itemStack2) {
        return this.itemProviders.stream().anyMatch(itemProvider -> itemProvider.compare(itemStack, itemStack2));
    }

    public ItemProvider getCustomItemProvider(ItemStack itemStack) {
        return this.itemProviders.stream().filter(itemProvider -> itemProvider.isValidItem(itemStack)).findFirst().orElse(null);
    }

    public void setup() {
        ListIterator<ItemProvider> listIterator = this.itemProviders.listIterator();
        while (listIterator.hasNext()) {
            ItemProvider itemProvider = (ItemProvider)listIterator.next();
            if (itemProvider.isReady()) {
                this.main.info("Enabled item provider for " + itemProvider.getName() + ".");
                continue;
            }
            listIterator.remove();
            this.main.info("Failed to load item provider for " + itemProvider.getName() + " within the allowed time.");
        }
    }
}

