/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.provider.item;

import com.dre.brewery.Brew;
import com.dre.brewery.api.BreweryApi;
import com.dre.brewery.recipe.BRecipe;
import net.brcdev.shopgui.provider.item.ItemProvider;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class BreweryItemProvider
extends ItemProvider {
    public BreweryItemProvider() {
        super("Brewery");
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        Brew brew = BreweryApi.getBrew((ItemStack)itemStack);
        if (brew == null) {
            return false;
        }
        return brew.getCurrentRecipe() != null;
    }

    @Override
    public ItemStack loadItem(ConfigurationSection configurationSection) {
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("brewery");
        if (configurationSection2 == null) {
            return null;
        }
        String string = configurationSection2.getString("recipe");
        int n = configurationSection2.getInt("quality");
        if (string == null || n == 0) {
            return null;
        }
        BRecipe bRecipe = BreweryApi.getRecipeMatch((String)string);
        if (bRecipe == null) {
            return null;
        }
        return bRecipe.createBrew(n).createItem(bRecipe);
    }

    @Override
    public boolean compare(ItemStack itemStack, ItemStack itemStack2) {
        if (!this.isValidItem(itemStack) || !this.isValidItem(itemStack2)) {
            return true;
        }
        Brew brew = BreweryApi.getBrew((ItemStack)itemStack);
        Brew brew2 = BreweryApi.getBrew((ItemStack)itemStack2);
        return brew.getCurrentRecipe().getRecipeName().equals(brew2.getCurrentRecipe().getRecipeName()) && brew.getQuality() == brew2.getQuality();
    }
}

