/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.event.ShopPostTransactionEvent;
import net.brcdev.shopgui.event.ShopPreTransactionEvent;
import net.brcdev.shopgui.event.ShopsPostLoadEvent;
import net.brcdev.shopgui.exception.item.ItemLoadException;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.exception.shop.ShopsNotLoadedException;
import net.brcdev.shopgui.gui.click.GuiClickActions;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElement;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElementType;
import net.brcdev.shopgui.gui.gui.OpenGui;
import net.brcdev.shopgui.gui.gui.ShopGui;
import net.brcdev.shopgui.gui.gui.ShopSelectionGui;
import net.brcdev.shopgui.inventory.ShopInventoryHolder;
import net.brcdev.shopgui.permission.PermissionManager;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.MainMenu;
import net.brcdev.shopgui.shop.MainMenuItem;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.shop.item.ShopItemPermission;
import net.brcdev.shopgui.shop.item.ShopItemType;
import net.brcdev.shopgui.sound.SoundAction;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.EnchantmentNames;
import net.brcdev.shopgui.util.InventoryUtils;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopManager {
    public Set<Shop> shops = new HashSet<Shop>();
    private boolean shopsLoaded = false;
    private ShopGuiPlugin main;
    private MainMenu mainMenu;

    public ShopManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.mainMenu = new MainMenu();
    }

    public Set<Shop> getShops() {
        if (!this.areShopsLoaded()) {
            throw new ShopsNotLoadedException();
        }
        return this.shops;
    }

    public boolean areShopsLoaded() {
        return this.shopsLoaded;
    }

    public void loadMainMenu() {
        this.mainMenu.load();
    }

    public MainMenuItem getMainMenuItemBySlot(int n) {
        return this.mainMenu.getMainMenuItemBySlot(n);
    }

    public String getShopIdBySlot(int n) {
        return this.mainMenu.getShopIdBySlot(n);
    }

    public Inventory getMainMenuInventory(Player player) {
        return this.mainMenu.getInventory(player);
    }

    public void load() {
        this.loadMainMenu();
        this.loadShops();
        this.shopsLoaded = true;
        Bukkit.getPluginManager().callEvent((Event)new ShopsPostLoadEvent());
    }

    public void openMainMenu(Player player) {
        this.openMainMenu(player, false);
    }

    public void openMainMenu(final Player player, final boolean bl) {
        if (!this.shopsLoaded) {
            player.sendMessage(Lang.MSG_NOTLOADED.toMsg());
            return;
        }
        this.main.getPlayerManager().handlePlayerData(player, new Callback<PlayerData>(){

            @Override
            public void onSuccess(PlayerData playerData) {
                ShopManager.this.main.getSoundManager().playSound(player, SoundAction.MAIN_MENU_OPEN);
                playerData.setAllowAllShopsAccessFromCurrentGui(bl);
                ShopSelectionGui shopSelectionGui = new ShopSelectionGui(player, playerData, OpenGui.MenuType.MAIN, null);
                InventoryUtils.openInventory(player, playerData, ShopManager.this.getMainMenuInventory(player), shopSelectionGui);
            }

            @Override
            public void onFailure(PlayerData playerData) {
                player.sendMessage(Lang.MSG_ERROR.toMsg());
            }
        });
    }

    public void loadShops() {
        Object object;
        String string;
        this.shops.clear();
        int n = 0;
        for (ConfigurationSection object2 : this.main.getShopFileManager().getShopsConfigs()) {
            string = object2.getName();
            if (this.getShopById(string) != null) {
                this.main.getLogger().info("Shop '" + string + "' already exists, duplicate shop not loaded.");
                continue;
            }
            object = this.loadShop(string, object2);
            this.shops.add((Shop)object);
        }
        for (Shop shop : this.shops) {
            string = shop.getId();
            object = this.loadShopItems(shop, this.main.getShopFileManager().getShopConfig(string));
            shop.setShopItems((List<ShopItem>)object);
            n += shop.getShopItems().size();
            this.main.getLogger().info("Loaded shop '" + string + "' with " + shop.getShopItems().size() + " items.");
        }
        this.main.getLogger().info("Loaded " + this.shops.size() + " shops with total of " + n + " items.");
    }

    private Shop loadShop(String string2, ConfigurationSection configurationSection) {
        ItemStack itemStack;
        Object object2;
        int n;
        if (configurationSection.getInt("size") == 0) {
            n = 54;
        } else if (configurationSection.getInt("size") % 9 != 0) {
            this.main.warning("Invalid shop size set for shop '" + string2 + "'. Valid values are 9, 18, 27, 36, 45 and 54. Using default size 54.");
            n = 54;
        } else {
            n = configurationSection.getInt("size");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (configurationSection.isConfigurationSection("namePerPage")) {
            for (Object object2 : configurationSection.getConfigurationSection("namePerPage").getKeys(false)) {
                hashMap.put(Integer.valueOf((String)object2), ChatUtils.fixColors(configurationSection.getConfigurationSection("namePerPage").getString((String)object2)));
            }
        }
        Object object3 = null;
        if (configurationSection.isSet("economy")) {
            try {
                object3 = EconomyType.valueOf(configurationSection.getString("economy"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.main.warning("Invalid economy provider specified for shop '" + string2 + "'. Valid values are " + ChatUtils.getValuesList(EconomyType.class) + ".");
            }
        }
        object2 = new ItemStack(Material.AIR, 1);
        if (configurationSection.isConfigurationSection("fillItem")) {
            try {
                object2 = ItemUtils.loadItemStackFromConfig(configurationSection, "fillItem");
            }
            catch (ItemLoadException itemLoadException) {
                // empty catch block
            }
        }
        GuiClickActions guiClickActions = new GuiClickActions();
        if (configurationSection.isConfigurationSection("clickActions")) {
            guiClickActions.load(configurationSection.getConfigurationSection("clickActions"), false);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (configurationSection.isList("worldsWhitelist")) {
            configurationSection.getStringList("worldsWhitelist").forEach(string -> arrayList.add(string.toLowerCase()));
        } else if (configurationSection.isList("worldsBlacklist")) {
            configurationSection.getStringList("worldsBlacklist").forEach(string -> arrayList2.add(string.toLowerCase()));
        }
        Shop shop = new Shop(string2, ChatUtils.fixColors(configurationSection.getString("name")), (Map<Integer, String>)hashMap, n, (EconomyType)((Object)object3), (ItemStack)object2, guiClickActions, (List<String>)arrayList, (List<String>)arrayList2);
        shop.setDenyDirectAccess(configurationSection.getBoolean("denyDirectAccess", false));
        shop.setEnablePerItemPermissions(configurationSection.getBoolean("enablePerItemPermissions", false));
        shop.setEnableBuyGUI(configurationSection.getBoolean("enableBuyGUI", Settings.enableBuyGUI));
        shop.setEnableSellGUI(configurationSection.getBoolean("enableSellGUI", Settings.enableSellGUI));
        shop.setEnableSellGUISellAll(configurationSection.getBoolean("enableSellGUISellAll", Settings.enableSellGUISellAll));
        if (configurationSection.isConfigurationSection("buttons.goBack")) {
            try {
                itemStack = ItemUtils.loadItemStackFromConfig(configurationSection, "buttons.goBack.item");
            }
            catch (ItemLoadException itemLoadException) {
                itemStack = Settings.buttonGoBack.getItemStack().clone();
            }
            if (itemStack == null) {
                itemStack = Settings.buttonGoBack.getItemStack().clone();
            }
            if (configurationSection.get("buttons.goBack.slots") != null) {
                List list = configurationSection.getIntegerList("buttons.goBack.slots");
                shop.setButtonGoBack(new GuiButton("goBack", itemStack, list));
            } else if (configurationSection.get("buttons.goBack.slot") != null) {
                int n2 = configurationSection.get("buttons.goBack.slot") == null ? Settings.buttonGoBack.getSlot() : configurationSection.getInt("buttons.goBack.slot");
                shop.setButtonGoBack(new GuiButton("goBack", itemStack, n2));
            }
        }
        if (configurationSection.isConfigurationSection("buttons.previousPage")) {
            try {
                itemStack = ItemUtils.loadItemStackFromConfig(configurationSection, "buttons.previousPage.item");
            }
            catch (ItemLoadException itemLoadException) {
                itemStack = Settings.buttonPreviousPage.getItemStack().clone();
            }
            if (itemStack == null) {
                itemStack = Settings.buttonPreviousPage.getItemStack().clone();
            }
            int n3 = configurationSection.get("buttons.previousPage.slot") == null ? Settings.buttonPreviousPage.getSlot() : configurationSection.getInt("buttons.previousPage.slot");
            shop.setButtonPreviousPage(new GuiButton("previousPage", itemStack, n3));
        }
        if (configurationSection.isConfigurationSection("buttons.nextPage")) {
            try {
                itemStack = ItemUtils.loadItemStackFromConfig(configurationSection, ".buttons.nextPage.item");
            }
            catch (ItemLoadException itemLoadException) {
                itemStack = Settings.buttonNextPage.getItemStack().clone();
            }
            if (itemStack == null) {
                itemStack = Settings.buttonNextPage.getItemStack().clone();
            }
            int n4 = configurationSection.get("buttons.nextPage.slot") == null ? Settings.buttonNextPage.getSlot() : configurationSection.getInt("buttons.nextPage.slot");
            shop.setButtonNextPage(new GuiButton("nextPage", itemStack, n4));
        }
        return shop;
    }

    private List<ShopItem> loadShopItems(Shop shop, ConfigurationSection configurationSection) {
        ArrayList<ShopItem> arrayList = new ArrayList<ShopItem>();
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("items");
        if (configurationSection2 == null) {
            return arrayList;
        }
        block23: for (String string : configurationSection2.getKeys(false)) {
            Object object;
            ShopItemType shopItemType;
            try {
                shopItemType = ShopItemType.getType(configurationSection2.getString(string + ".type").toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                this.main.warning("Invalid or missing item type specified for item " + shop.getId() + " > " + string + ", item not loaded. Valid values are " + ChatUtils.getValuesList(ShopItemType.class));
                continue;
            }
            ItemStack itemStack = null;
            if (shopItemType != ShopItemType.SPECIAL) {
                try {
                    itemStack = ItemUtils.loadItemStackFromConfig(configurationSection2, string + ".item");
                    if (itemStack.getType() == Material.AIR) {
                        throw new ItemLoadException("Shop Item Material cannot be air!");
                    }
                }
                catch (ItemLoadException itemLoadException) {
                    this.main.warning("Error occurred when loading " + shop.getId() + " > " + string + ", item not loaded: " + itemLoadException.getMessage());
                    continue;
                }
            }
            int n = configurationSection2.getInt(string + ".page", 1);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            if (configurationSection2.isList(string + ".slots")) {
                for (String string2 : configurationSection2.getStringList(string + ".slots")) {
                    try {
                        arrayList2.add(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (configurationSection2.isInt(string + ".slot")) {
                arrayList2.add(configurationSection2.getInt(string + ".slot"));
            }
            if (arrayList2.isEmpty()) {
                this.main.warning("No slot specified for item " + shop.getId() + " > " + string + ", item not loaded.");
                continue;
            }
            boolean bl = configurationSection2.getBoolean(string + ".unstack", false);
            boolean bl2 = configurationSection2.getBoolean(string + ".stacked", false);
            ShopItem shopItem = shopItemType == ShopItemType.SPECIAL || shopItemType == ShopItemType.DUMMY ? new ShopItem(shop, string, shopItemType) : (shopItemType == ShopItemType.SHOP_LINK ? new ShopItem(shop, string, shopItemType, itemStack) : new ShopItem(shop, string, shopItemType, itemStack, bl, bl2, n, configurationSection2.getDouble(string + ".buyPrice", -1.0), configurationSection2.getDouble(string + ".sellPrice", -1.0), itemStack.getAmount()));
            switch (shopItemType) {
                case ITEM: {
                    shopItem.setStripMeta(configurationSection2.getBoolean(string + ".stripItemMeta", Settings.defaultItemSettingsStripItemMeta));
                    shopItem.setCompareMeta(configurationSection2.getBoolean(string + ".compareMeta", Settings.defaultItemSettingsCompareMeta));
                    shopItem.setCompareModel(configurationSection2.getBoolean(string + ".compareModel", Settings.defaultItemSettingsCompareModel));
                    shopItem.setCompareDamage(configurationSection2.getBoolean(string + ".compareDamage", Settings.defaultItemSettingsCompareDamage));
                    shopItem.setCompareNbt(configurationSection2.getBoolean(string + ".compareNbt", Settings.defaultItemSettingsCompareNbt));
                    int n2 = configurationSection2.getInt(string + ".maxStackSize") > 0 ? configurationSection2.getInt(string + ".maxStackSize") : -1;
                    shopItem.setItemStackSizeCappedAt(n2);
                    break;
                }
                case PERMISSION: {
                    String string3;
                    Object object2;
                    Object object3;
                    if (!this.main.enablePermissions()) {
                        this.main.warning("Permissions are not enabled, item " + shop.getId() + " > " + string + " not loaded.");
                        continue block23;
                    }
                    object = new ArrayList<ShopItemPermission>();
                    if (configurationSection2.isString(string + ".permission")) {
                        object.add(new ShopItemPermission(configurationSection2.getString(string + ".permission"), null));
                    } else if (configurationSection2.isList(string + ".permissions")) {
                        object3 = configurationSection2.getStringList(string + ".permissions");
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            String string4 = (String)iterator.next();
                            object.add((ShopItemPermission)new ShopItemPermission(string4, null));
                        }
                    } else if (configurationSection2.isConfigurationSection(string + ".permissions")) {
                        object3 = configurationSection2.getConfigurationSection(string + ".permissions");
                        for (String string5 : object3.getKeys(false)) {
                            object2 = object3.getString(string5 + ".permission");
                            if (object2 == null) {
                                this.main.warning("Missing permissions for item " + shop.getId() + " > " + string + ", item not loaded.");
                                continue;
                            }
                            string3 = object3.getString(string5 + ".world");
                            object.add((ShopItemPermission)new ShopItemPermission((String)object2, string3));
                        }
                    } else {
                        this.main.warning("Missing permissions for item " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    shopItem.setPermissions((List<ShopItemPermission>)object);
                    shopItem.setForce(configurationSection2.getBoolean(string + ".force"));
                    break;
                }
                case ENCHANTMENT: {
                    int n3;
                    int n4;
                    Object object3;
                    try {
                        object3 = EnchantmentNames.getEnchantment(configurationSection2.getString(string + ".enchantment"));
                        n4 = configurationSection2.getInt(string + ".enchantmentLevel");
                        n3 = configurationSection2.getInt(string + ".enchantmentStackSizeLimit");
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        this.main.warning("Missing or invalid enchantment type/level for item " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    if (object3 == null) {
                        this.main.warning("Missing or invalid enchantment type/level for item " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    shopItem.setEnchantment((Enchantment)object3);
                    shopItem.setEnchantmentLevel(n4);
                    shopItem.setEnchantmentStackSizeLimit(n3);
                    break;
                }
                case COMMAND: {
                    Object object2;
                    try {
                        object2 = configurationSection2.getStringList(string + ".commands");
                    }
                    catch (NullPointerException nullPointerException) {
                        this.main.warning("Missing commands for item " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    shopItem.setRequireInventorySpace(configurationSection2.getBoolean(string + ".requireInventorySpace"));
                    shopItem.setCommands((List<String>)object2);
                    shopItem.setRunSingleCommand(configurationSection2.getBoolean(string + ".runSingleCommand"));
                    shopItem.setRunCommandsAsBuyer(configurationSection2.getBoolean(string + ".runAsBuyer"));
                    shopItem.setCommandsLimit(configurationSection2.getInt(string + ".commandsLimit", itemStack.getAmount()));
                    break;
                }
                case SHOP_LINK: {
                    String string3 = configurationSection2.getString(string + ".shop");
                    if (string3 == null || this.getShopById(string3) == null) {
                        this.main.warning("Invalid shop ID specified for shop link " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    shopItem.setShopLinkShopId(string3);
                    shopItem.setPage(n);
                    break;
                }
                case SPECIAL: {
                    GuiSpecialElementType guiSpecialElementType;
                    try {
                        guiSpecialElementType = GuiSpecialElementType.valueOf(configurationSection2.getString(string + ".special").toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.main.warning("Invalid special item type specified for " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    GuiSpecialElement guiSpecialElement = Settings.getGuiSpecialElement(guiSpecialElementType);
                    if (guiSpecialElement == null) {
                        this.main.warning("Invalid special item type specified for " + shop.getId() + " > " + string + ", item not loaded.");
                        continue block23;
                    }
                    shopItem.setSpecialElement(guiSpecialElement);
                    shopItem.setItem(guiSpecialElement.getItemStack());
                    shopItem.setPage(n);
                    break;
                }
                case DUMMY: {
                    shopItem.setItem(itemStack);
                    shopItem.setPage(n);
                    break;
                }
            }
            ItemStack itemStack2 = null;
            if (configurationSection2.isConfigurationSection(string + ".placeholder")) {
                try {
                    itemStack2 = ItemUtils.loadItemStackFromConfig(configurationSection2, string + ".placeholder");
                }
                catch (ItemLoadException itemLoadException) {
                    itemStack2 = shopItem.getItem().clone();
                }
            } else {
                itemStack2 = shopItem.getItem().clone();
            }
            shopItem.setPlaceholder(itemStack2);
            shopItem.setCloseGuiOnClick(configurationSection2.getBoolean(string + ".closeGuiOnClick"));
            if (configurationSection2.isString(string + ".messageBuy")) {
                shopItem.setMessageBuy(configurationSection2.getString(string + ".messageBuy"));
            }
            if (configurationSection2.isString(string + ".messageSell")) {
                shopItem.setMessageSell(configurationSection2.getString(string + ".messageSell"));
            }
            if (configurationSection2.isString(string + ".messageSellAll")) {
                shopItem.setMessageSellAll(configurationSection2.getString(string + ".messageSellAll"));
            }
            if (configurationSection2.isList(string + ".requiredPermissions")) {
                shopItem.setRequiredPermissions(configurationSection2.getStringList(string + ".requiredPermissions"));
            }
            if (configurationSection2.isList(string + ".commandsOnClick")) {
                shopItem.setCommandsOnClick(configurationSection2.getStringList(string + ".commandsOnClick"));
            }
            if (configurationSection2.isList(string + ".commandsOnBuy")) {
                shopItem.setCommandsOnBuy(configurationSection2.getStringList(string + ".commandsOnBuy"));
            }
            if (configurationSection2.isList(string + ".commandsOnSell")) {
                shopItem.setCommandsOnSell(configurationSection2.getStringList(string + ".commandsOnSell"));
            }
            if (configurationSection2.isList(string + ".commandsOnClickConsole")) {
                shopItem.setCommandsOnClickConsole(configurationSection2.getStringList(string + ".commandsOnClickConsole"));
            }
            if (configurationSection2.isList(string + ".commandsOnBuyConsole")) {
                shopItem.setCommandsOnBuyConsole(configurationSection2.getStringList(string + ".commandsOnBuyConsole"));
            }
            if (configurationSection2.isList(string + ".commandsOnSellConsole")) {
                shopItem.setCommandsOnSellConsole(configurationSection2.getStringList(string + ".commandsOnSellConsole"));
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                int n5 = (Integer)object.next();
                ShopItem shopItem2 = new ShopItem(shopItem);
                shopItem2.setSlot(n5);
                arrayList.add(shopItem2);
            }
        }
        return arrayList;
    }

    public Shop getShopById(String string) {
        for (Shop shop : this.shops) {
            if (!shop.getId().equalsIgnoreCase(string)) continue;
            return shop;
        }
        return null;
    }

    private void addShopLore(ItemStack itemStack, Player player, Shop shop, ShopItem shopItem, double d, double d2) {
        int n;
        ShopItemType shopItemType = shopItem.getType();
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> arrayList = null;
        switch (shopItemType) {
            case ITEM: {
                arrayList = new ArrayList<String>(Settings.shopItemLoreFormatItem);
                break;
            }
            case PERMISSION: {
                arrayList = new ArrayList<String>(Settings.shopItemLoreFormatPermission);
                break;
            }
            case ENCHANTMENT: {
                arrayList = new ArrayList<String>(Settings.shopItemLoreFormatEnchantment);
                break;
            }
            case COMMAND: {
                arrayList = new ArrayList<String>(Settings.shopItemLoreFormatCommand);
                break;
            }
        }
        if (arrayList == null) {
            return;
        }
        String string = d < 0.0 ? Settings.buyPriceForUnsellablePlaceholder : ChatUtils.formatCurrencyString(shop, d);
        String string2 = d2 < 0.0 ? Settings.sellPriceForUnsellablePlaceholder : ChatUtils.formatCurrencyString(shop, d2);
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if (Settings.hideBuyPriceForUnbuyable && d < 0.0 && string3.toLowerCase().contains("%buy%")) {
                listIterator.remove();
            }
            if (!Settings.hideSellPriceForUnsellable || !(d2 < 0.0) || !string3.toLowerCase().contains("%sell%") && !string3.toLowerCase().contains("%sellall%") && !string3.toLowerCase().contains("sell-all") && !string3.toLowerCase().contains("sell all") && !string3.toLowerCase().contains("sellall")) continue;
            listIterator.remove();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.set(n, ChatUtils.fixColors(((String)arrayList.get(n)).replace("%buy%", string).replace("%sell%", string2)));
        }
        if (shopItemType == ShopItemType.PERMISSION) {
            n = 1;
            for (ShopItemPermission shopItemPermission : shopItem.getPermissions()) {
                if (!shopItemPermission.has(player)) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                if (!Lang.SHOP_PERMISSION_ALREADYOWNED.toString().isEmpty()) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList.set(i, ((String)arrayList.get(i)).replace("%owned%", Lang.SHOP_PERMISSION_ALREADYOWNED.toString()));
                    }
                }
            } else {
                listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    String string4 = (String)listIterator.next();
                    if (!string4.toLowerCase().contains("%owned%")) continue;
                    if (Lang.SHOP_PERMISSION_NOTOWNED.toString().isEmpty()) {
                        listIterator.remove();
                        continue;
                    }
                    listIterator.set(string4.replace("%owned%", Lang.SHOP_PERMISSION_NOTOWNED.toString()));
                }
            }
        }
        if (itemMeta.hasLore()) {
            List list = itemMeta.getLore();
            list.addAll(arrayList);
            itemMeta.setLore(list);
        } else {
            itemMeta.setLore(arrayList);
        }
        itemStack.setItemMeta(itemMeta);
    }

    public void openShopMenu(Player player, String string, boolean bl) {
        this.openShopMenu(player, string, 1, bl);
    }

    public void openShopMenu(Player player, String string, int n, boolean bl) {
        Shop shop = this.getShopById(string);
        if (shop != null) {
            this.openShopMenu(player, shop, n, bl);
        } else {
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_INVALIDSHOP.toString().replace("%shop%", string));
        }
    }

    public void openShopMenu(Player player, Shop shop, boolean bl) {
        this.openShopMenu(player, shop, 1, bl);
    }

    public void openShopMenu(Player player, Shop shop, int n, boolean bl) {
        Object object;
        PlayerData playerData;
        if (!this.shopsLoaded) {
            player.sendMessage(Lang.MSG_NOTLOADED.toMsg());
            return;
        }
        if (bl && shop.isDenyDirectAccess()) {
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NODIRECTACCESSTOSHOP.toString().replace("%shop%", shop.getName(n).replace("%page%", "1")));
            return;
        }
        try {
            playerData = this.main.getPlayerManager().getPlayerData((OfflinePlayer)player);
        }
        catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
            playerDataNotLoadedException.printStackTrace();
            player.sendMessage(Lang.MSG_ERROR.toMsg());
            return;
        }
        if (!(playerData.isAllowAllShopsAccessFromCurrentGui() || !bl && Settings.disableSudoShopPermissionCheck || shop.hasAccess(player))) {
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESSTOSHOP.toString().replace("%shop%", shop.getName(n).replace("%page%", "1")));
            return;
        }
        if (!PermissionManager.hasPermission(player, "shopguiplus.bypassworld")) {
            if (!shop.getWorldsWhitelist().isEmpty()) {
                if (!shop.getWorldsWhitelist().contains(player.getWorld().getName().toLowerCase())) {
                    player.sendMessage(Lang.MSG_WORLDBLACKLISTED.toMsg().replace("%shop%", shop.getName()));
                    return;
                }
            } else if (!shop.getWorldsBlacklist().isEmpty() && shop.getWorldsBlacklist().contains(player.getWorld().getName().toLowerCase())) {
                player.sendMessage(Lang.MSG_WORLDBLACKLISTED.toMsg().replace("%shop%", shop.getName()));
                return;
            }
        }
        HashMap<Integer, Inventory> hashMap = new HashMap<Integer, Inventory>();
        for (ShopItem shopItem : shop.getShopItems()) {
            ItemStack itemStack;
            int n2 = shopItem.getPage();
            int n3 = shopItem.getSlot();
            if (!hashMap.containsKey(n2)) {
                itemStack = this.getShopInventory(shop, n2);
                hashMap.put(n2, (Inventory)itemStack);
            }
            itemStack = shopItem.getPlaceholder().clone();
            if (shopItem.getType() == ShopItemType.SPECIAL) {
                GuiSpecialElement guiSpecialElement = shopItem.getSpecialElement();
                guiSpecialElement.setSlot(n3);
                switch (guiSpecialElement.getType()) {
                    case BALANCE: {
                        guiSpecialElement.replacePlaceholder("%balance%", ChatUtils.formatCurrencyString(shop, shop.getEconomyProvider().getBalance(player)));
                        break;
                    }
                }
                guiSpecialElement.setInInventory(hashMap.get(n2));
                continue;
            }
            this.addShopLore(itemStack, player, shop, shopItem, shopItem.getBuyPrice(player), shopItem.getSellPrice(player));
            try {
                hashMap.get(n2).setItem(n3, itemStack);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.main.warning("Slot number is bigger than the size of the inventory! (shop > " + shop.getId() + " > " + shopItem.getId() + ")");
            }
        }
        if (hashMap.isEmpty()) {
            object = this.getShopInventory(shop, 1);
            hashMap.put(1, (Inventory)object);
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            int n4 = (Integer)object.next();
            shop.getButtonGoBack().setInInventory((Inventory)hashMap.get(n4));
            if (hashMap.containsKey(n4 - 1)) {
                shop.getButtonPreviousPage().setInInventory(hashMap.get(n4));
            }
            if (!hashMap.containsKey(n4 + 1)) continue;
            shop.getButtonNextPage().setInInventory(hashMap.get(n4));
        }
        for (Inventory inventory : hashMap.values()) {
            for (int i = 0; i < inventory.getContents().length; ++i) {
                if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
                inventory.setItem(i, shop.getFillItem().clone());
            }
        }
        this.main.getSoundManager().playSound(player, SoundAction.SHOP_OPEN);
        object = new ShopGui(player, playerData, OpenGui.MenuType.SHOP, shop, hashMap, n);
        InventoryUtils.openInventory(player, playerData, hashMap.get(n), (OpenGui)object);
    }

    private Inventory getShopInventory(Shop shop, int n) {
        String string = shop.getName(n).replace("%page%", String.valueOf(n));
        String string2 = !NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && string.length() > 32 ? string.substring(0, 32) : string;
        return new ShopInventoryHolder(shop.getSize(), string2).getInventory();
    }

    @Deprecated
    public ShopItem findShopItemByItemStack(Player player, PlayerData playerData, ItemStack itemStack, boolean bl) {
        return this.findShopItemByItemStack(player, itemStack, bl);
    }

    public ShopItem findShopItemByItemStack(Player player, ItemStack itemStack, boolean bl) {
        boolean bl2 = Settings.sellAllFindMaxSellPrice;
        ShopItem shopItem = null;
        if (bl2) {
            for (Shop shop : this.shops) {
                ShopItem shopItem2;
                if (!shop.hasAccess(player) || (shopItem2 = shop.findShopItem(player, itemStack, bl)) == null || shopItem != null && !(shopItem.getSellPrice(player) < shopItem2.getSellPrice(player))) continue;
                shopItem = shopItem2;
            }
        } else {
            for (Shop shop : this.shops) {
                if (!shop.hasAccess(player) || (shopItem = shop.findShopItem(player, itemStack, bl)) == null) continue;
                return shopItem;
            }
        }
        return shopItem;
    }

    public ShopItem findShopItemByItemStack(ItemStack itemStack, boolean bl) {
        boolean bl2 = Settings.sellAllFindMaxSellPrice;
        ShopItem shopItem = null;
        if (bl2) {
            for (Shop shop : this.shops) {
                ShopItem shopItem2 = shop.findShopItem(itemStack, bl);
                if (shopItem2 == null || shopItem != null && !(shopItem.getSellPrice() < shopItem2.getSellPrice())) continue;
                shopItem = shopItem2;
            }
        } else {
            for (Shop shop : this.shops) {
                shopItem = shop.findShopItem(itemStack, bl);
                if (shopItem == null) continue;
                return shopItem;
            }
        }
        return shopItem;
    }

    public void closeAllGuis() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.closeGui(player);
        }
    }

    public void closeGui(final Player player) {
        if (!this.main.getPlayerManager().isPlayerLoaded((OfflinePlayer)player)) {
            return;
        }
        if (player.getOpenInventory().getTopInventory() != null) {
            final Inventory inventory = player.getOpenInventory().getTopInventory();
            this.main.getPlayerManager().handlePlayerData(player, new Callback<PlayerData>(){

                @Override
                public void onSuccess(PlayerData playerData) {
                    if (playerData.hasOpenGui()) {
                        if (playerData.getOpenGui().getType() == OpenGui.MenuType.SHOP) {
                            ShopGui shopGui = (ShopGui)playerData.getOpenGui();
                            if (shopGui.getShopInventory() != null) {
                                for (int n : shopGui.getShopInventory().keySet()) {
                                    if (!InventoryUtils.compareInventories(inventory, shopGui.getShopInventory().get(n))) continue;
                                    player.closeInventory();
                                    return;
                                }
                            }
                        } else {
                            player.closeInventory();
                        }
                    }
                }

                @Override
                public void onFailure(PlayerData playerData) {
                }
            });
        }
    }

    public ShopTransactionResult handleItemBuy(Player player, ShopItem shopItem, int n, boolean bl) {
        ShopTransactionResult.ShopTransactionResultType shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.SUCCESS;
        ItemStack itemStack = shopItem.getItem().clone();
        Shop shop = shopItem.getShop();
        double d = shopItem.getBuyPriceForAmount(player, n);
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(ShopAction.BUY, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        if (shopPreTransactionEvent.isCancelled()) {
            shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED;
        } else {
            d = shopPreTransactionEvent.getPrice();
            n = shopPreTransactionEvent.getAmount();
            itemStack.setAmount(n);
            if (!shop.getEconomyProvider().has(player, d)) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_MONEY;
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_CANNOTAFFORD.toString().replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)));
            } else {
                int n2;
                boolean bl2 = true;
                if (shopItem.isUnstack()) {
                    if (InventoryUtils.countEmptyInventorySlots(player) < n) {
                        bl2 = false;
                    }
                } else {
                    n2 = shopItem.isStacked() ? Math.min(Math.min(n, shopItem.getMaxStackSize()), 64) : (Settings.enforceDefaultStackSize ? shopItem.getItem().getMaxStackSize() : shopItem.getMaxStackSize());
                    if (!InventoryUtils.canPlayerCarryItem(player, itemStack, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt(), n2)) {
                        bl2 = false;
                    }
                }
                if (!bl2) {
                    shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_FULL_INVENTORY;
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_FULLINVENTORY.toString());
                } else {
                    shop.getEconomyProvider().withdraw(player, d);
                    if (shopItem.isStripMeta() && !ItemUtils.isSpawner(itemStack)) {
                        itemStack = ItemUtils.stripItemMeta(itemStack);
                    }
                    if (shopItem.isUnstack()) {
                        InventoryUtils.addItemToInventory(player, itemStack, 1);
                    } else {
                        n2 = shopItem.isStacked() ? Math.min(Math.min(itemStack.getAmount(), shopItem.getMaxStackSize()), 64) : (Settings.enforceDefaultStackSize ? itemStack.getMaxStackSize() : shopItem.getMaxStackSize());
                        InventoryUtils.addItemToInventory(player, itemStack, n2);
                    }
                    this.main.logTransaction(Settings.logFormatBuy.replace("%player%", player.getName()).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()));
                    player.updateInventory();
                    this.main.getSoundManager().playSound(player, SoundAction.BUY_ITEM);
                    if (bl) {
                        String string = !shopItem.getMessageBuy().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageBuy()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_ITEM_BOUGHTFREE.toString() : Lang.MSG_ITEM_BOUGHT.toString());
                        player.sendMessage((Object)((Object)Lang.PREFIX) + string.replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)));
                    }
                    for (String string : shopItem.getCommandsOnBuyConsole()) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                    }
                    for (String string : shopItem.getCommandsOnBuy()) {
                        Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                    }
                }
            }
        }
        ShopTransactionResult shopTransactionResult = new ShopTransactionResult(ShopAction.BUY, shopTransactionResultType, shopItem, player, n, d);
        ShopPostTransactionEvent shopPostTransactionEvent = new ShopPostTransactionEvent(shopTransactionResult);
        Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
        return shopTransactionResult;
    }

    public ShopTransactionResult handleItemSell(Player player, ShopItem shopItem, int n, boolean bl, boolean bl2) {
        Object object2;
        ShopTransactionResult.ShopTransactionResultType shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.SUCCESS;
        ItemStack itemStack = shopItem.getItem().clone();
        itemStack.setAmount(n);
        Shop shop = shopItem.getShop();
        double d = shopItem.getSellPriceForAmount(player, n);
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(ShopAction.SELL, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        if (shopPreTransactionEvent.isCancelled()) {
            shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED;
        } else {
            d = shopPreTransactionEvent.getPrice();
            n = shopPreTransactionEvent.getAmount();
            if (InventoryUtils.getPlayersItemAmount(player, itemStack, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt(), Settings.sellAllExcludeArmorSlots) < n) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_ITEMS;
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_NOTENOUGH.toString().replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)));
            } else {
                InventoryUtils.removeItemFromPlayer(player, itemStack, n, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt());
                shop.getEconomyProvider().deposit(player, d);
                if (bl2) {
                    this.main.logTransaction(Settings.logFormatSell.replace("%player%", player.getName()).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()));
                }
                this.main.getSoundManager().playSound(player, SoundAction.SELL_ITEM);
                if (bl) {
                    object2 = !shopItem.getMessageSell().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageSell()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_ITEM_SOLDFREE.toString() : Lang.MSG_ITEM_SOLD.toString());
                    player.sendMessage((Object)((Object)Lang.PREFIX) + ((String)object2).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)));
                }
                for (String object3 : shopItem.getCommandsOnSellConsole()) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)object3.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
                for (String string : shopItem.getCommandsOnSell()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
            }
        }
        object2 = new ShopTransactionResult(ShopAction.SELL, shopTransactionResultType, shopItem, player, n, d);
        ShopPostTransactionEvent shopPostTransactionEvent = new ShopPostTransactionEvent((ShopTransactionResult)object2);
        Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
        return object2;
    }

    public ShopTransactionResult handleItemSellHand(Player player, ShopItem shopItem, int n, boolean bl, boolean bl2) {
        Object object2;
        ShopTransactionResult.ShopTransactionResultType shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.SUCCESS;
        ItemStack itemStack = shopItem.getItem().clone();
        itemStack.setAmount(n);
        Shop shop = shopItem.getShop();
        double d = shopItem.getSellPriceForAmount(player, n);
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(ShopAction.SELL, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        if (shopPreTransactionEvent.isCancelled()) {
            shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED;
        } else {
            d = shopPreTransactionEvent.getPrice();
            n = shopPreTransactionEvent.getAmount();
            if (InventoryUtils.getPlayersItemAmountInHand(player, itemStack, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt()) < n) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_ITEMS;
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_NOTENOUGH.toString().replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)));
            } else {
                InventoryUtils.removeItemFromPlayersHand(player, itemStack, n, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt());
                shop.getEconomyProvider().deposit(player, d);
                if (bl2) {
                    this.main.logTransaction(Settings.logFormatSell.replace("%player%", player.getName()).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()));
                }
                this.main.getSoundManager().playSound(player, SoundAction.SELL_ITEM);
                if (bl) {
                    object2 = !shopItem.getMessageSell().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageSell()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_ITEM_SOLDFREE.toString() : Lang.MSG_ITEM_SOLD.toString());
                    player.sendMessage((Object)((Object)Lang.PREFIX) + ((String)object2).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)));
                }
                for (String object3 : shopItem.getCommandsOnSellConsole()) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)object3.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
                for (String string : shopItem.getCommandsOnSell()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
            }
        }
        object2 = new ShopTransactionResult(ShopAction.SELL, shopTransactionResultType, shopItem, player, n, d);
        ShopPostTransactionEvent shopPostTransactionEvent = new ShopPostTransactionEvent((ShopTransactionResult)object2);
        Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
        return object2;
    }

    public ShopTransactionResult handleItemSellAll(Player player, ShopItem shopItem, boolean bl) {
        Object object2;
        double d;
        int n;
        ShopTransactionResult.ShopTransactionResultType shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.SUCCESS;
        ItemStack itemStack = shopItem.getItem().clone();
        Shop shop = shopItem.getShop();
        if (Settings.allowAllSellAllStackSizes) {
            n = InventoryUtils.getPlayersItemAmount(player, itemStack, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt(), Settings.sellAllExcludeArmorSlots);
            d = shopItem.getSellPrice(player) / (double)shopItem.getOriginalStackSize() * (double)n;
            if (n == 0) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_ITEMS;
            }
        } else {
            int n2 = InventoryUtils.getPlayersItemAmount(player, itemStack, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt(), Settings.sellAllExcludeArmorSlots) / itemStack.getAmount();
            n = n2 * itemStack.getAmount();
            d = shopItem.getSellPrice(player) * (double)itemStack.getAmount() / (double)shopItem.getOriginalStackSize() * (double)n2;
            if (n2 < 1) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_ITEMS;
                if (bl) {
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_NOTENOUGH.toString().replace("%amount%", String.valueOf(itemStack.getAmount())).replace("%item%", ItemUtils.formatItemName(itemStack, player)));
                }
            }
        }
        d = Settings.parsePrice(d);
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(ShopAction.SELL_ALL, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        if (shopPreTransactionEvent.isCancelled()) {
            shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED;
        }
        if (shopTransactionResultType == ShopTransactionResult.ShopTransactionResultType.SUCCESS) {
            d = shopPreTransactionEvent.getPrice();
            n = shopPreTransactionEvent.getAmount();
            InventoryUtils.removeItemFromPlayer(player, itemStack, n, shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt());
            shop.getEconomyProvider().deposit(player, d);
            this.main.logTransaction(Settings.logFormatSellAll.replace("%player%", player.getName()).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()));
            this.main.getSoundManager().playSound(player, SoundAction.SELL_ALL_ITEM);
            if (bl) {
                object2 = !shopItem.getMessageSellAll().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageSellAll()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_ITEM_SOLDALLFREE.toString() : Lang.MSG_ITEM_SOLDALL.toString());
                player.sendMessage((Object)((Object)Lang.PREFIX) + ((String)object2).replace("%amount%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, player)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)));
            }
            if (Settings.closeGuiAfterSellAll) {
                player.closeInventory();
            }
            for (String object3 : shopItem.getCommandsOnSellConsole()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)object3.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
            }
            for (String string : shopItem.getCommandsOnSell()) {
                Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
            }
        }
        object2 = new ShopTransactionResult(ShopAction.SELL_ALL, shopTransactionResultType, shopItem, player, n, d);
        ShopPostTransactionEvent shopPostTransactionEvent = new ShopPostTransactionEvent((ShopTransactionResult)object2);
        Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
        return object2;
    }

    public ShopTransactionResult handleCommandBuy(Player player, ShopItem shopItem, int n, boolean bl) {
        Object object;
        ShopTransactionResult shopTransactionResult;
        ShopTransactionResult.ShopTransactionResultType shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.SUCCESS;
        Shop shop = shopItem.getShop();
        double d = shopItem.getBuyPriceForAmount(player, n);
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(ShopAction.BUY, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        if (shopPreTransactionEvent.isCancelled()) {
            shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED;
        } else {
            d = shopPreTransactionEvent.getPrice();
            n = shopPreTransactionEvent.getAmount();
            if (!shop.getEconomyProvider().has(player, d)) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_MONEY;
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_COMMAND_CANNOTAFFORD.toString().replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%command%", ItemUtils.formatItemName(shopItem.getItem().clone(), player)));
            } else if (shopItem.isRequireInventorySpace() && player.getInventory().firstEmpty() == -1) {
                shopTransactionResultType = ShopTransactionResult.ShopTransactionResultType.FAILURE_FULL_INVENTORY;
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_FULLINVENTORY.toString().replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%command%", ItemUtils.formatItemName(shopItem.getItem().clone(), player)));
            } else {
                if (!Settings.returnToShop) {
                    player.closeInventory();
                }
                shop.getEconomyProvider().withdraw(player, d);
                Object object2 = shopTransactionResult = shopItem.isRunCommandsAsBuyer() ? player : Bukkit.getConsoleSender();
                if (shopItem.isRunSingleCommand()) {
                    for (String object3 : shopItem.getCommands()) {
                        Bukkit.dispatchCommand((CommandSender)shopTransactionResult, (String)object3.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        for (String string : shopItem.getCommands()) {
                            Bukkit.dispatchCommand((CommandSender)shopTransactionResult, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                        }
                    }
                }
                if (bl) {
                    object = !shopItem.getMessageBuy().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageBuy()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_COMMAND_BOUGHTFREE.toMsg() : Lang.MSG_COMMAND_BOUGHT.toMsg());
                    player.sendMessage(((String)object).replace("%amount%", String.valueOf(n)).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%command%", ItemUtils.formatItemName(shopItem.getItem(), player)));
                }
                for (String string : shopItem.getCommandsOnBuyConsole()) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
                for (String string : shopItem.getCommandsOnBuy()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
                }
                this.main.logTransaction(Settings.logFormatBuyCommand.replace("%amount%", String.valueOf(n)).replace("%player%", player.getName()).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()).replace("%command%", ItemUtils.formatItemName(shopItem.getItem(), player)));
            }
        }
        shopTransactionResult = new ShopTransactionResult(ShopAction.BUY, shopTransactionResultType, shopItem, player, n, d);
        object = new ShopPostTransactionEvent(shopTransactionResult);
        Bukkit.getPluginManager().callEvent((Event)object);
        return shopTransactionResult;
    }

    public static enum ShopAction {
        BUY,
        SELL,
        SELL_ALL;

    }

    public static enum MainMenuItemType {
        SHOP,
        SPECIAL,
        DUMMY;

    }
}

